/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.IntegerBucketResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class IntegerBucketResultNodeVector
extends ResultNodeVector {
    public static final int classId = IntegerBucketResultNodeVector.registerClass((int)16496, IntegerBucketResultNodeVector.class, IntegerBucketResultNodeVector::new);
    private ArrayList<IntegerBucketResultNode> vector = new ArrayList();

    public IntegerBucketResultNodeVector add(IntegerBucketResultNode v) {
        this.vector.add(v);
        return this;
    }

    public ArrayList<IntegerBucketResultNode> getVector() {
        return this.vector;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((IntegerBucketResultNode)r);
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (IntegerBucketResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            IntegerBucketResultNode node = new IntegerBucketResultNode(0L, 0L);
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        IntegerBucketResultNodeVector b = (IntegerBucketResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

