/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.Group;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class GroupingLevel
extends Identifiable {
    public static final int classId = GroupingLevel.registerClass((int)16477, GroupingLevel.class, GroupingLevel::new);
    private long maxGroups = -1L;
    private long precision = -1L;
    private ExpressionNode classify = null;
    private Group collect = new Group();

    public long getPrecision() {
        return this.precision;
    }

    public long getMaxGroups() {
        return this.maxGroups;
    }

    public GroupingLevel setMaxGroups(long max) {
        this.maxGroups = max;
        if (this.precision < this.maxGroups) {
            this.precision = this.maxGroups;
        }
        return this;
    }

    public GroupingLevel setPrecision(long precision) {
        this.precision = precision;
        return this;
    }

    public ExpressionNode getExpression() {
        return this.classify;
    }

    public GroupingLevel setExpression(ExpressionNode exp) {
        this.classify = exp;
        return this;
    }

    public GroupingLevel setGroupPrototype(Group group) {
        this.collect = group;
        return this;
    }

    public Group getGroupPrototype() {
        return this.collect;
    }

    public boolean needResultCollection() {
        return !this.collect.isRankedByRelevance();
    }

    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putLong(null, this.maxGroups);
        buf.putLong(null, this.precision);
        GroupingLevel.serializeOptional((Serializer)buf, (Identifiable)this.classify);
        this.collect.serializeWithId(buf);
    }

    protected void onDeserialize(Deserializer buf) {
        this.maxGroups = buf.getLong(null);
        this.precision = buf.getLong(null);
        this.classify = (ExpressionNode)GroupingLevel.deserializeOptional((Deserializer)buf);
        this.collect.deserializeWithId(buf);
    }

    public int hashCode() {
        return super.hashCode() + (int)this.maxGroups + (int)this.precision + this.collect.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GroupingLevel rhs = (GroupingLevel)((Object)obj);
        if (this.maxGroups != rhs.maxGroups) {
            return false;
        }
        if (this.precision != rhs.precision) {
            return false;
        }
        if (!GroupingLevel.equals((Object)this.classify, (Object)rhs.classify)) {
            return false;
        }
        return this.collect.equals((Object)rhs.collect);
    }

    public GroupingLevel clone() {
        GroupingLevel obj = (GroupingLevel)super.clone();
        if (this.classify != null) {
            obj.classify = this.classify.clone();
        }
        obj.collect = this.collect.clone();
        return obj;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("maxGroups", (Object)this.maxGroups);
        visitor.visit("precision", (Object)this.precision);
        visitor.visit("classify", (Object)this.classify);
        visitor.visit("collect", (Object)this.collect);
    }
}

