/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.hll.HyperLogLogEstimator;
import com.yahoo.searchlib.aggregation.hll.Sketch;
import com.yahoo.searchlib.aggregation.hll.SketchMerger;
import com.yahoo.searchlib.aggregation.hll.SparseSketch;
import com.yahoo.searchlib.aggregation.hll.UniqueCountEstimator;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class ExpressionCountAggregationResult
extends AggregationResult {
    public static final int classId = ExpressionCountAggregationResult.registerClass((int)16472, ExpressionCountAggregationResult.class, ExpressionCountAggregationResult::new);
    private static final int UNDEFINED = -1;
    private final UniqueCountEstimator<Sketch<?>> estimator;
    private final SketchMerger sketchMerger = new SketchMerger();
    private Sketch<?> sketch;
    private long estimatedUniqueCount = -1L;

    public ExpressionCountAggregationResult() {
        this(new SparseSketch(), new HyperLogLogEstimator());
    }

    public ExpressionCountAggregationResult(Sketch<?> initialSketch, UniqueCountEstimator<Sketch<?>> estimator) {
        this.sketch = initialSketch;
        this.estimator = estimator;
    }

    public long getEstimatedUniqueCount() {
        if (this.estimatedUniqueCount == -1L) {
            this.updateEstimate();
        }
        return this.estimatedUniqueCount;
    }

    @Override
    public ResultNode getRank() {
        return new IntegerResultNode(this.getEstimatedUniqueCount());
    }

    @Override
    protected void onMerge(AggregationResult result) {
        ExpressionCountAggregationResult other = (ExpressionCountAggregationResult)result;
        this.sketch = this.sketchMerger.merge(this.sketch, other.sketch);
        this.estimatedUniqueCount = -1L;
    }

    public Sketch<?> getSketch() {
        return this.sketch;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        this.sketch.serializeWithId(buf);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.sketch = (Sketch)ExpressionCountAggregationResult.create((Deserializer)buf);
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        ExpressionCountAggregationResult other = (ExpressionCountAggregationResult)obj;
        return this.sketch.equals(other.sketch);
    }

    private void updateEstimate() {
        this.estimatedUniqueCount = this.estimator.estimateCount(this.sketch);
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("sketch", this.sketch);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sketch.hashCode();
        return result;
    }
}

