/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.FunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.NameNode;
import com.yahoo.searchlib.rankingexpression.rule.NegativeNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.text.Utf8;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExpressionFunction {
    private final String name;
    private final List<String> arguments;
    private final Map<String, TensorType> argumentTypes;
    private final RankingExpression body;
    private final Optional<TensorType> returnType;

    public ExpressionFunction(String name, RankingExpression body) {
        this(name, Collections.emptyList(), body);
    }

    public ExpressionFunction(String name, List<String> arguments, RankingExpression body) {
        this(name, arguments, body, Map.of(), Optional.empty());
    }

    public ExpressionFunction(String name, List<String> arguments, RankingExpression body, Map<String, TensorType> argumentTypes, Optional<TensorType> returnType) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.arguments = arguments == null ? List.of() : List.copyOf(arguments);
        this.body = Objects.requireNonNull(body, "body cannot be null");
        if (!this.arguments.containsAll(argumentTypes.keySet())) {
            throw new IllegalArgumentException("Argument type keys must be a subset of the argument keys");
        }
        this.argumentTypes = Map.copyOf(argumentTypes);
        this.returnType = Objects.requireNonNull(returnType, "returnType cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public RankingExpression getBody() {
        return this.body;
    }

    public Map<String, TensorType> argumentTypes() {
        return this.argumentTypes;
    }

    public TensorType getArgumentType(String argumentName) {
        return this.argumentTypes.get(argumentName);
    }

    public Optional<TensorType> returnType() {
        return this.returnType;
    }

    public ExpressionFunction withName(String name) {
        return new ExpressionFunction(name, this.arguments, this.body, this.argumentTypes, this.returnType);
    }

    public ExpressionFunction withBody(RankingExpression body) {
        return new ExpressionFunction(this.name, this.arguments, body, this.argumentTypes, this.returnType);
    }

    public ExpressionFunction withReturnType(TensorType returnType) {
        return new ExpressionFunction(this.name, this.arguments, this.body, this.argumentTypes, Optional.of(returnType));
    }

    public ExpressionFunction withArgument(String argument) {
        if (this.arguments.contains(argument)) {
            return this;
        }
        ArrayList<String> arguments = new ArrayList<String>(this.arguments);
        arguments.add(argument);
        return new ExpressionFunction(this.name, arguments, this.body, this.argumentTypes, this.returnType);
    }

    public ExpressionFunction withArgument(String argument, TensorType type) {
        ArrayList<String> arguments = new ArrayList<String>(this.arguments);
        if (!arguments.contains(argument)) {
            arguments.add(argument);
        }
        HashMap<String, TensorType> argumentTypes = new HashMap<String, TensorType>(this.argumentTypes);
        argumentTypes.put(argument, type);
        return new ExpressionFunction(this.name, arguments, this.body, argumentTypes, this.returnType);
    }

    public Instance expand(SerializationContext context, List<ExpressionNode> argumentValues, Deque<String> path) {
        HashMap<String, String> argumentBindings = new HashMap<String, String>();
        for (int i = 0; i < this.arguments.size() && i < argumentValues.size(); ++i) {
            String key = this.arguments.get(i);
            ExpressionNode expr = argumentValues.get(i);
            String binding = expr.toString(new StringBuilder(), context, path, null).toString();
            if (this.shouldGenerateFeature(expr)) {
                String funcName = "autogenerated_ranking_feature@" + Long.toHexString(ExpressionFunction.symbolCode(key + "=" + binding));
                context.addFunctionSerialization(RankingExpression.propertyName(funcName), binding);
                binding = Reference.wrapInRankingExpression(funcName);
            }
            argumentBindings.put(key, binding);
        }
        context = argumentBindings.isEmpty() ? context.withoutBindings() : context.withBindings(argumentBindings);
        String symbol = this.toSymbol(argumentBindings);
        String expressionString = this.body.getRoot().toString(new StringBuilder(), context, path, null).toString();
        return new Instance(symbol, expressionString);
    }

    private boolean shouldGenerateFeature(ExpressionNode expr) {
        if (expr instanceof ConstantNode) {
            return false;
        }
        if (expr instanceof ReferenceNode) {
            return false;
        }
        if (expr instanceof NameNode) {
            return false;
        }
        if (expr instanceof FunctionNode) {
            return false;
        }
        return !(expr instanceof NegativeNode) || !(((NegativeNode)expr).getValue() instanceof ConstantNode);
    }

    private String toSymbol(Map<String, String> argumentBindings) {
        if (argumentBindings.isEmpty()) {
            return this.name;
        }
        StringBuilder ret = new StringBuilder();
        ret.append(this.name).append("@");
        for (Map.Entry<String, String> argumentBinding : argumentBindings.entrySet()) {
            ret.append(Long.toHexString(ExpressionFunction.symbolCode(argumentBinding.getKey() + "=" + argumentBinding.getValue())));
            ret.append(".");
        }
        if (ret.toString().endsWith(".")) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }

    private static long symbolCode(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buf = md.digest(Utf8.toBytes((String)str));
            if (buf.length >= 8) {
                long ret = 0L;
                for (int i = 0; i < 8; ++i) {
                    ret = (ret << 8) + (long)(buf[i] & 0xFF);
                }
                return ret;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("java must always support SHA-1 message digest format", e);
        }
        return str.hashCode();
    }

    public String toString() {
        return "function '" + this.name + "'";
    }

    public class Instance {
        private final String name;
        private final String expressionString;

        public Instance(String name, String expressionString) {
            this.name = name;
            this.expressionString = expressionString;
        }

        public String getName() {
            return this.name;
        }

        public String getExpressionString() {
            return this.expressionString;
        }
    }
}

