/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class TranslogserverConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c1ce57179c37c70725be8631e6ab0ef0";
    public static final String CONFIG_DEF_NAME = "translogserver";
    public static final String CONFIG_DEF_NAMESPACE = "searchlib";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=searchlib", "listenport int default=13700 restart", "filesizemax int default=50000000", "servername string default=\"tls\" restart", "basedir string default=\"tmp\" restart", "usefsync bool default=true", "maxthreads int default=0 restart", "crcmethod enum {ccitt_crc32, xxh64} default=xxh64", "compression.type enum {NONE, NONE_MULTI, LZ4, ZSTD} default=ZSTD", "compression.level int default=3", "chunk.sizelimit int default = 256000"};
    private final IntegerNode listenport;
    private final IntegerNode filesizemax;
    private final StringNode servername;
    private final StringNode basedir;
    private final BooleanNode usefsync;
    private final IntegerNode maxthreads;
    private final Crcmethod crcmethod;
    private final Compression compression;
    private final Chunk chunk;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public TranslogserverConfig(Builder builder) {
        this(builder, true);
    }

    private TranslogserverConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for translogserver must be initialized: " + builder.__uninitialized);
        }
        this.listenport = builder.listenport == null ? new IntegerNode(13700) : new IntegerNode(builder.listenport.intValue());
        this.filesizemax = builder.filesizemax == null ? new IntegerNode(50000000) : new IntegerNode(builder.filesizemax.intValue());
        this.servername = builder.servername == null ? new StringNode("tls") : new StringNode(builder.servername);
        this.basedir = builder.basedir == null ? new StringNode("tmp") : new StringNode(builder.basedir);
        this.usefsync = builder.usefsync == null ? new BooleanNode(true) : new BooleanNode(builder.usefsync.booleanValue());
        this.maxthreads = builder.maxthreads == null ? new IntegerNode(0) : new IntegerNode(builder.maxthreads.intValue());
        this.crcmethod = builder.crcmethod == null ? new Crcmethod(Crcmethod.xxh64) : new Crcmethod(builder.crcmethod);
        this.compression = new Compression(builder.compression, throwIfUninitialized);
        this.chunk = new Chunk(builder.chunk, throwIfUninitialized);
    }

    public int listenport() {
        return this.listenport.value();
    }

    public int filesizemax() {
        return this.filesizemax.value();
    }

    public String servername() {
        return this.servername.value();
    }

    public String basedir() {
        return this.basedir.value();
    }

    public boolean usefsync() {
        return this.usefsync.value();
    }

    public int maxthreads() {
        return this.maxthreads.value();
    }

    public Crcmethod.Enum crcmethod() {
        return (Crcmethod.Enum)((Object)this.crcmethod.value());
    }

    public Compression compression() {
        return this.compression;
    }

    public Chunk chunk() {
        return this.chunk;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TranslogserverConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.listenport, (Node)newConfig.listenport, "listenport", "Port number to use for listening.");
        changes.compare((Node)this.servername, (Node)newConfig.servername, "servername", "Server name to identify server.");
        changes.compare((Node)this.basedir, (Node)newConfig.basedir, "basedir", "Base directory. The default is not used as it is decided by the model.");
        changes.compare((Node)this.maxthreads, (Node)newConfig.maxthreads, "maxthreads", "Number of threads available for visiting/subscription.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer listenport = null;
        private Integer filesizemax = null;
        private String servername = null;
        private String basedir = null;
        private Boolean usefsync = null;
        private Integer maxthreads = null;
        private Crcmethod.Enum crcmethod = null;
        public Compression.Builder compression = new Compression.Builder();
        public Chunk.Builder chunk = new Chunk.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(TranslogserverConfig config) {
            this.listenport(config.listenport());
            this.filesizemax(config.filesizemax());
            this.servername(config.servername());
            this.basedir(config.basedir());
            this.usefsync(config.usefsync());
            this.maxthreads(config.maxthreads());
            this.crcmethod(config.crcmethod());
            this.compression(new Compression.Builder(config.compression()));
            this.chunk(new Chunk.Builder(config.chunk()));
        }

        private Builder override(Builder __superior) {
            if (__superior.listenport != null) {
                this.listenport(__superior.listenport);
            }
            if (__superior.filesizemax != null) {
                this.filesizemax(__superior.filesizemax);
            }
            if (__superior.servername != null) {
                this.servername(__superior.servername);
            }
            if (__superior.basedir != null) {
                this.basedir(__superior.basedir);
            }
            if (__superior.usefsync != null) {
                this.usefsync(__superior.usefsync);
            }
            if (__superior.maxthreads != null) {
                this.maxthreads(__superior.maxthreads);
            }
            if (__superior.crcmethod != null) {
                this.crcmethod(__superior.crcmethod);
            }
            this.compression(this.compression.override(__superior.compression));
            this.chunk(this.chunk.override(__superior.chunk));
            return this;
        }

        public Builder listenport(int __value) {
            this.listenport = __value;
            return this;
        }

        private Builder listenport(String __value) {
            return this.listenport(Integer.valueOf(__value));
        }

        public Builder filesizemax(int __value) {
            this.filesizemax = __value;
            return this;
        }

        private Builder filesizemax(String __value) {
            return this.filesizemax(Integer.valueOf(__value));
        }

        public Builder servername(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.servername = __value;
            return this;
        }

        public Builder basedir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.basedir = __value;
            return this;
        }

        public Builder usefsync(boolean __value) {
            this.usefsync = __value;
            return this;
        }

        private Builder usefsync(String __value) {
            return this.usefsync(Boolean.valueOf(__value));
        }

        public Builder maxthreads(int __value) {
            this.maxthreads = __value;
            return this;
        }

        private Builder maxthreads(String __value) {
            return this.maxthreads(Integer.valueOf(__value));
        }

        public Builder crcmethod(Crcmethod.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.crcmethod = __value;
            return this;
        }

        private Builder crcmethod(String __value) {
            return this.crcmethod(Crcmethod.Enum.valueOf(__value));
        }

        public Builder compression(Compression.Builder __builder) {
            this.compression = __builder;
            return this;
        }

        public Builder compression(Consumer<Compression.Builder> __func) {
            Compression.Builder __inner = new Compression.Builder();
            __func.accept(__inner);
            this.compression = __inner;
            return this;
        }

        public Builder chunk(Chunk.Builder __builder) {
            this.chunk = __builder;
            return this;
        }

        public Builder chunk(Consumer<Chunk.Builder> __func) {
            Chunk.Builder __inner = new Chunk.Builder();
            __func.accept(__inner);
            this.chunk = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return TranslogserverConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return TranslogserverConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return TranslogserverConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public TranslogserverConfig build() {
            return new TranslogserverConfig(this);
        }
    }

    public static final class Crcmethod
    extends EnumNode<Enum> {
        public static final Enum ccitt_crc32 = Enum.ccitt_crc32;
        public static final Enum xxh64 = Enum.xxh64;

        public Crcmethod() {
            this.value = null;
        }

        public Crcmethod(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ccitt_crc32,
            xxh64;

        }
    }

    public static final class Compression
    extends InnerNode {
        private final Type type;
        private final IntegerNode level;

        public Compression(Builder builder) {
            this(builder, true);
        }

        private Compression(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for translogserver.compression must be initialized: " + builder.__uninitialized);
            }
            this.type = builder.type == null ? new Type(Type.ZSTD) : new Type(builder.type);
            this.level = builder.level == null ? new IntegerNode(3) : new IntegerNode(builder.level.intValue());
        }

        public Type.Enum type() {
            return (Type.Enum)((Object)this.type.value());
        }

        public int level() {
            return this.level.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Type.Enum type = null;
            private Integer level = null;

            public Builder() {
            }

            public Builder(Compression config) {
                this.type(config.type());
                this.level(config.level());
            }

            private Builder override(Builder __superior) {
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                if (__superior.level != null) {
                    this.level(__superior.level);
                }
                return this;
            }

            public Builder type(Type.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                return this;
            }

            private Builder type(String __value) {
                return this.type(Type.Enum.valueOf(__value));
            }

            public Builder level(int __value) {
                this.level = __value;
                return this;
            }

            private Builder level(String __value) {
                return this.level(Integer.valueOf(__value));
            }

            public Compression build() {
                return new Compression(this);
            }
        }

        public static final class Type
        extends EnumNode<Enum> {
            public static final Enum NONE = Enum.NONE;
            public static final Enum NONE_MULTI = Enum.NONE_MULTI;
            public static final Enum LZ4 = Enum.LZ4;
            public static final Enum ZSTD = Enum.ZSTD;

            public Type() {
                this.value = null;
            }

            public Type(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                NONE,
                NONE_MULTI,
                LZ4,
                ZSTD;

            }
        }
    }

    public static final class Chunk
    extends InnerNode {
        private final IntegerNode sizelimit;

        public Chunk(Builder builder) {
            this(builder, true);
        }

        private Chunk(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for translogserver.chunk must be initialized: " + builder.__uninitialized);
            }
            this.sizelimit = builder.sizelimit == null ? new IntegerNode(256000) : new IntegerNode(builder.sizelimit.intValue());
        }

        public int sizelimit() {
            return this.sizelimit.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Chunk newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("chunk");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer sizelimit = null;

            public Builder() {
            }

            public Builder(Chunk config) {
                this.sizelimit(config.sizelimit());
            }

            private Builder override(Builder __superior) {
                if (__superior.sizelimit != null) {
                    this.sizelimit(__superior.sizelimit);
                }
                return this;
            }

            public Builder sizelimit(int __value) {
                this.sizelimit = __value;
                return this;
            }

            private Builder sizelimit(String __value) {
                return this.sizelimit(Integer.valueOf(__value));
            }

            public Chunk build() {
                return new Chunk(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

