/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public final class ReferenceNode
extends CompositeNode {
    private final Reference reference;

    public ReferenceNode(String name) {
        this.reference = Reference.simple(name).orElseGet(() -> Reference.fromIdentifier(name));
    }

    public ReferenceNode(String name, List<? extends ExpressionNode> arguments, String output) {
        this.reference = new Reference(name, arguments != null ? new Arguments(arguments) : Arguments.EMPTY, output);
    }

    public ReferenceNode(Reference reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.reference.name();
    }

    public Arguments getArguments() {
        return this.reference.arguments();
    }

    public ReferenceNode setArguments(List<ExpressionNode> arguments) {
        return new ReferenceNode(this.reference.withArguments(new Arguments(arguments)));
    }

    public String getOutput() {
        return this.reference.output();
    }

    public ReferenceNode setOutput(String output) {
        return new ReferenceNode(this.reference.withOutput(output));
    }

    @Override
    public List<ExpressionNode> children() {
        return this.reference.arguments().expressions();
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        if (this.reference.isIdentifier() && context.getBinding(this.getName()) != null) {
            return string.append(context.getBinding(this.getName()));
        }
        ExpressionFunction function = context.getFunction(this.getName());
        if (function != null && function.arguments().size() == this.getArguments().size() && this.getOutput() == null) {
            boolean needSerialization;
            String myPath;
            if (path == null) {
                path = new ArrayDeque<String>();
            }
            if (path.contains(myPath = this.getName() + this.getArguments().expressions())) {
                throw new IllegalArgumentException("Cycle in ranking expression function '" + this.getName() + "' called from: " + path);
            }
            path.addLast(myPath);
            String functionName = this.getName();
            boolean bl = needSerialization = this.getArguments().size() > 0 || context.needSerialization(functionName);
            if (needSerialization) {
                ExpressionFunction.Instance instance = function.expand(context, this.getArguments().expressions(), path);
                functionName = instance.getName();
                context.addFunctionSerialization(RankingExpression.propertyName(functionName), instance.getExpressionString());
                for (Map.Entry<String, TensorType> argumentType : function.argumentTypes().entrySet()) {
                    context.addArgumentTypeSerialization(functionName, argumentType.getKey(), argumentType.getValue());
                }
                if (function.returnType().isPresent()) {
                    context.addFunctionTypeSerialization(functionName, function.returnType().get());
                }
            }
            path.removeLast();
            return string.append(Reference.wrapInRankingExpression(functionName));
        }
        return this.reference.toString(string, context, path, parent);
    }

    public Reference reference() {
        return this.reference;
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        TensorType type = null;
        try {
            type = context.getType((Name)this.reference);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.reference + " is invalid", e);
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown feature '" + this + "'");
        }
        return type;
    }

    @Override
    public Value evaluate(Context context) {
        if (this.reference.isIdentifier()) {
            return context.get(this.reference.name());
        }
        return context.get(this.getName(), this.getArguments(), this.getOutput());
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> newChildren) {
        return this.setArguments(newChildren);
    }

    @Override
    public int hashCode() {
        return this.reference.hashCode();
    }
}

