/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.Int32ResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class Int32ResultNodeVector
extends ResultNodeVector {
    public static final int classId = Int32ResultNodeVector.registerClass((int)16502, Int32ResultNodeVector.class);
    private ArrayList<Int32ResultNode> vector = new ArrayList();

    public Int32ResultNodeVector add(Int32ResultNode v) {
        this.vector.add(v);
        return this;
    }

    public ArrayList<Int32ResultNode> getVector() {
        return this.vector;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((Int32ResultNode)r);
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (Int32ResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            Int32ResultNode node = new Int32ResultNode(0);
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        Int32ResultNodeVector b = (Int32ResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

