/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.RawBucketResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class RawBucketResultNodeVector
extends ResultNodeVector {
    public static final int classId = RawBucketResultNodeVector.registerClass((int)16510, RawBucketResultNodeVector.class);
    private ArrayList<RawBucketResultNode> vector = new ArrayList();

    @Override
    protected int onGetClassId() {
        return classId;
    }

    public RawBucketResultNodeVector add(RawBucketResultNode v) {
        this.vector.add(v);
        return this;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((RawBucketResultNode)r);
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    public ArrayList<RawBucketResultNode> getVector() {
        return this.vector;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (RawBucketResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            RawBucketResultNode node = new RawBucketResultNode();
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        RawBucketResultNodeVector b = (RawBucketResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

