/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.MultiArgFunctionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class MathFunctionNode
extends MultiArgFunctionNode {
    public static final int classId = MathFunctionNode.registerClass((int)16520, MathFunctionNode.class);
    private Function fnc;

    public MathFunctionNode() {
        this(Function.LOG);
    }

    public MathFunctionNode(Function fnc) {
        this(null, fnc);
    }

    public MathFunctionNode(ExpressionNode exp, Function fnc) {
        this.fnc = fnc;
        if (exp != null) {
            this.addArg(exp);
        }
    }

    @Override
    protected boolean onExecute() {
        this.getArg(0).execute();
        double result = 0.0;
        switch (this.fnc) {
            case EXP: {
                result = Math.exp(this.getArg(0).getResult().getFloat());
                break;
            }
            case POW: {
                result = Math.pow(this.getArg(0).getResult().getFloat(), this.getArg(1).getResult().getFloat());
                break;
            }
            case LOG: {
                result = Math.log(this.getArg(0).getResult().getFloat());
                break;
            }
            case LOG1P: {
                result = Math.log1p(this.getArg(0).getResult().getFloat());
                break;
            }
            case LOG10: {
                result = Math.log10(this.getArg(0).getResult().getFloat());
                break;
            }
            case SIN: {
                result = Math.sin(this.getArg(0).getResult().getFloat());
                break;
            }
            case ASIN: {
                result = Math.asin(this.getArg(0).getResult().getFloat());
                break;
            }
            case COS: {
                result = Math.cos(this.getArg(0).getResult().getFloat());
                break;
            }
            case ACOS: {
                result = Math.acos(this.getArg(0).getResult().getFloat());
                break;
            }
            case TAN: {
                result = Math.tan(this.getArg(0).getResult().getFloat());
                break;
            }
            case ATAN: {
                result = Math.atan(this.getArg(0).getResult().getFloat());
                break;
            }
            case SQRT: {
                result = Math.sqrt(this.getArg(0).getResult().getFloat());
                break;
            }
            case SINH: {
                result = Math.sinh(this.getArg(0).getResult().getFloat());
                break;
            }
            case ASINH: {
                throw new IllegalArgumentException("Inverse hyperbolic sine(asinh) is not supported in java");
            }
            case COSH: {
                result = Math.cosh(this.getArg(0).getResult().getFloat());
                break;
            }
            case ACOSH: {
                throw new IllegalArgumentException("Inverse hyperbolic cosine (acosh) is not supported in java");
            }
            case TANH: {
                result = Math.tanh(this.getArg(0).getResult().getFloat());
                break;
            }
            case ATANH: {
                throw new IllegalArgumentException("Inverse hyperbolic tangents (atanh) is not supported in java");
            }
            case FLOOR: {
                result = Math.floor(this.getArg(0).getResult().getFloat());
                break;
            }
            case CBRT: {
                result = Math.cbrt(this.getArg(0).getResult().getFloat());
                break;
            }
            case HYPOT: {
                result = Math.hypot(this.getArg(0).getResult().getFloat(), this.getArg(1).getResult().getFloat());
            }
        }
        ((FloatResultNode)this.getResult()).setValue(result);
        return true;
    }

    @Override
    public void onPrepareResult() {
        this.setResult(new FloatResultNode());
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putByte(null, (byte)this.fnc.id);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        byte b = buf.getByte(null);
        this.fnc = Function.valueOf(b & 0xFF);
    }

    @Override
    protected boolean equalsMultiArgFunction(MultiArgFunctionNode obj) {
        return this.fnc == ((MathFunctionNode)obj).fnc;
    }

    @Override
    public MathFunctionNode clone() {
        MathFunctionNode obj = (MathFunctionNode)super.clone();
        obj.fnc = this.fnc;
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("function", (Object)this.fnc);
    }

    public static enum Function {
        EXP(0),
        POW(1),
        LOG(2),
        LOG1P(3),
        LOG10(4),
        SIN(5),
        ASIN(6),
        COS(7),
        ACOS(8),
        TAN(9),
        ATAN(10),
        SQRT(11),
        SINH(12),
        ASINH(13),
        COSH(14),
        ACOSH(15),
        TANH(16),
        ATANH(17),
        CBRT(18),
        HYPOT(19),
        FLOOR(20);

        private final int id;

        private Function(int id) {
            this.id = id;
        }

        private static Function valueOf(int id) {
            for (Function fnc : Function.values()) {
                if (id != fnc.id) continue;
                return fnc;
            }
            return null;
        }
    }
}

