/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.gbdt;

import com.yahoo.searchlib.gbdt.FeatureNode;
import com.yahoo.searchlib.gbdt.NumericFeatureNode;
import com.yahoo.searchlib.gbdt.ResponseNode;
import com.yahoo.searchlib.gbdt.TreeNode;
import com.yahoo.searchlib.gbdt.XmlHelper;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GbdtModel {
    private final List<TreeNode> trees;

    public GbdtModel(List<TreeNode> trees) {
        this.trees = GbdtModel.asForest(trees);
    }

    public List<TreeNode> trees() {
        return this.trees;
    }

    public String toRankingExpression() {
        if (!this.hasSampleInformation()) {
            System.err.println("The model nodes does not have the 'nSamples' attribute. For optimal runtime performance use an 'ext' model which has this information.");
        }
        StringBuilder ret = new StringBuilder();
        for (TreeNode tree : this.trees) {
            if (ret.length() > 0) {
                ret.append(" +\n");
            }
            ret.append(tree.toRankingExpression());
        }
        ret.append("\n");
        return ret.toString();
    }

    private boolean hasSampleInformation() {
        if (this.trees.size() == 0) {
            return true;
        }
        return this.trees.get(0).samples() != null;
    }

    public static GbdtModel fromXml(String xml) throws ParserConfigurationException, IOException, SAXException {
        return GbdtModel.fromDom(XmlHelper.parseXml(xml));
    }

    public static GbdtModel fromXmlFile(String fileName) throws ParserConfigurationException, IOException, SAXException {
        return GbdtModel.fromDom(XmlHelper.parseXmlFile(fileName));
    }

    public static GbdtModel fromDom(Node doc) {
        Element dtree = XmlHelper.getSingleElement(doc, "DecisionTree");
        Element forest = XmlHelper.getSingleElement(dtree, "Forest");
        List<Element> trees = XmlHelper.getChildElements(forest, "Tree");
        if (trees.isEmpty()) {
            throw new IllegalArgumentException("Forest has no trees.");
        }
        ArrayList<TreeNode> model = new ArrayList<TreeNode>();
        for (Node node : trees) {
            if (XmlHelper.getChildElements(node, null).isEmpty()) continue;
            model.add(TreeNode.fromDom(XmlHelper.getSingleElement(node, null)));
        }
        return new GbdtModel(model);
    }

    private static List<TreeNode> asForest(List<TreeNode> in) {
        ArrayList<TreeNode> out = new ArrayList<TreeNode>(in.size());
        for (TreeNode node : in) {
            if (node instanceof FeatureNode) {
                out.add(node);
                continue;
            }
            if (node instanceof ResponseNode) {
                out.add(new NumericFeatureNode("value(0)", new DoubleValue(1.0), node.samples(), node, new ResponseNode(0.0, Optional.of(0))));
                continue;
            }
            throw new UnsupportedOperationException(node.getClass().getName());
        }
        return Collections.unmodifiableList(out);
    }
}

