/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.ForceLoad;
import com.yahoo.searchlib.aggregation.Group;
import com.yahoo.searchlib.aggregation.GroupingLevel;
import com.yahoo.searchlib.expression.BucketResultNode;
import com.yahoo.searchlib.expression.NullResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Grouping
extends Identifiable {
    public static final int classId;
    private int id = 0;
    private boolean valid = true;
    private boolean all = false;
    private long topN = -1L;
    private int firstLevel = 0;
    private int lastLevel = 0;
    private boolean forceSinglePass = false;
    private List<GroupingLevel> groupingLevels = new ArrayList<GroupingLevel>();
    private Group root = new Group();
    private boolean postMergeCompleted = false;

    public Grouping() {
    }

    public Grouping(int id) {
        this.setId(id);
    }

    public void merge(Grouping rhs) {
        this.root.merge(this.firstLevel, 0, rhs.root);
    }

    public void postMerge() {
        if (this.postMergeCompleted) {
            return;
        }
        this.root.postMerge(this.groupingLevels, this.firstLevel, 0);
        this.postMergeCompleted = true;
    }

    public int getId() {
        return this.id;
    }

    public Grouping setId(int id) {
        this.id = id;
        return this;
    }

    public boolean valid() {
        return this.valid;
    }

    public boolean getAll() {
        return this.all;
    }

    public Grouping setAll(boolean all) {
        this.all = all;
        return this;
    }

    public long getTopN() {
        return this.topN;
    }

    public Grouping setTopN(long topN) {
        this.topN = topN;
        return this;
    }

    public int getFirstLevel() {
        return this.firstLevel;
    }

    public Grouping setFirstLevel(int level) {
        this.firstLevel = level;
        return this;
    }

    public int getLastLevel() {
        return this.lastLevel;
    }

    public Grouping setLastLevel(int level) {
        this.lastLevel = level;
        return this;
    }

    public List<GroupingLevel> getLevels() {
        return this.groupingLevels;
    }

    public Grouping addLevel(GroupingLevel level) {
        this.groupingLevels.add(Objects.requireNonNull(level));
        return this;
    }

    public Group getRoot() {
        return this.root;
    }

    public Grouping setRoot(Group root) {
        this.root = Objects.requireNonNull(root);
        return this;
    }

    public boolean getForceSinglePass() {
        return this.forceSinglePass;
    }

    public Grouping setForceSinglePass(boolean forceSinglePass) {
        this.forceSinglePass = forceSinglePass;
        return this;
    }

    public boolean useSinglePass() {
        return this.needDeepResultCollection() || this.getForceSinglePass();
    }

    public boolean needDeepResultCollection() {
        if (this.forceSinglePass) {
            return true;
        }
        for (GroupingLevel level : this.groupingLevels) {
            if (!level.needResultCollection()) continue;
            return true;
        }
        return false;
    }

    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putInt(null, this.id);
        byte tmp = this.valid ? (byte)1 : 0;
        buf.putByte(null, tmp);
        tmp = this.all ? (byte)1 : 0;
        buf.putByte(null, tmp);
        buf.putLong(null, this.topN);
        buf.putInt(null, this.firstLevel);
        buf.putInt(null, this.lastLevel);
        buf.putInt(null, this.groupingLevels.size());
        for (GroupingLevel level : this.groupingLevels) {
            level.serializeWithId(buf);
        }
        this.root.serializeWithId(buf);
    }

    protected void onDeserialize(Deserializer buf) {
        this.id = buf.getInt(null);
        byte tmp = buf.getByte(null);
        this.valid = tmp != 0;
        tmp = buf.getByte(null);
        this.all = tmp != 0;
        this.topN = buf.getLong(null);
        this.firstLevel = buf.getInt(null);
        this.lastLevel = buf.getInt(null);
        int numLevels = buf.getInt(null);
        for (int i = 0; i < numLevels; ++i) {
            GroupingLevel level = new GroupingLevel();
            level.deserializeWithId(buf);
            this.groupingLevels.add(level);
        }
        this.root.deserializeWithId(buf);
    }

    public int hashCode() {
        return super.hashCode() + this.id + (this.valid ? 66 : 99) + (this.all ? 666 : 999) + (int)this.topN + this.groupingLevels.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Grouping rhs = (Grouping)((Object)obj);
        if (this.id != rhs.id) {
            return false;
        }
        if (this.valid != rhs.valid) {
            return false;
        }
        if (this.all != rhs.all) {
            return false;
        }
        if (this.topN != rhs.topN) {
            return false;
        }
        if (this.firstLevel != rhs.firstLevel) {
            return false;
        }
        if (this.lastLevel != rhs.lastLevel) {
            return false;
        }
        if (!this.groupingLevels.equals(rhs.groupingLevels)) {
            return false;
        }
        return this.root.equals((Object)rhs.root);
    }

    public Grouping clone() {
        Grouping obj = (Grouping)super.clone();
        obj.groupingLevels = new ArrayList<GroupingLevel>();
        for (GroupingLevel level : this.groupingLevels) {
            obj.groupingLevels.add(level.clone());
        }
        obj.root = this.root.clone();
        return obj;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("id", (Object)this.id);
        visitor.visit("valid", (Object)this.valid);
        visitor.visit("all", (Object)this.all);
        visitor.visit("topN", (Object)this.topN);
        visitor.visit("firstLevel", (Object)this.firstLevel);
        visitor.visit("lastLevel", (Object)this.lastLevel);
        visitor.visit("groupingLevels", this.groupingLevels);
        visitor.visit("root", (Object)this.root);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        Grouping.selectGroups(predicate, operation, this.root, this.firstLevel, this.lastLevel, 0);
    }

    public void unifyNull() {
        class FindGroup
        implements ObjectPredicate {
            FindGroup() {
            }

            public boolean check(Object obj) {
                return obj instanceof Group;
            }
        }
        class UnifyNullGroupId
        implements ObjectOperation {
            UnifyNullGroupId() {
            }

            public void execute(Object obj) {
                Group group = (Group)((Object)obj);
                ResultNode id = group.getId();
                if (id instanceof BucketResultNode && ((BucketResultNode)id).empty()) {
                    group.setId(new NullResultNode());
                }
            }
        }
        this.selectMembers(new FindGroup(), new UnifyNullGroupId());
    }

    private static void selectGroups(ObjectPredicate predicate, ObjectOperation operation, Group group, int first, int last, int current) {
        if (current > last) {
            return;
        }
        if (current >= first) {
            group.select(predicate, operation);
        }
        for (Group child : group.getChildren()) {
            Grouping.selectGroups(predicate, operation, child, first, last, current + 1);
        }
    }

    static {
        ForceLoad.forceLoad();
        com.yahoo.searchlib.expression.ForceLoad.forceLoad();
        classId = Grouping.registerClass((int)16475, Grouping.class);
    }
}

