/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.FunctionReferenceContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class SerializationContext
extends FunctionReferenceContext {
    private final Map<String, String> serializedFunctions;
    private final Optional<TypeContext<Reference>> typeContext;

    public SerializationContext() {
        this(Collections.emptyList());
    }

    @Deprecated(forRemoval=true, since="7")
    public SerializationContext(Collection<ExpressionFunction> functions) {
        this(functions, Collections.emptyMap(), Optional.empty(), new LinkedHashMap<String, String>());
    }

    public SerializationContext(Collection<ExpressionFunction> functions, Optional<TypeContext<Reference>> typeContext) {
        this(functions, Collections.emptyMap(), typeContext, new LinkedHashMap<String, String>());
    }

    @Deprecated(forRemoval=true, since="7")
    public SerializationContext(Map<String, ExpressionFunction> functions) {
        this(functions.values());
    }

    @Deprecated(forRemoval=true, since="7")
    public SerializationContext(Collection<ExpressionFunction> functions, Map<String, String> bindings) {
        this(functions, bindings, Optional.empty(), new LinkedHashMap<String, String>());
    }

    public SerializationContext(Collection<ExpressionFunction> functions, Map<String, String> bindings, TypeContext<Reference> typeContext) {
        this(functions, bindings, Optional.of(typeContext), new LinkedHashMap<String, String>());
    }

    private SerializationContext(Collection<ExpressionFunction> functions, Map<String, String> bindings, Optional<TypeContext<Reference>> typeContext, Map<String, String> serializedFunctions) {
        this(SerializationContext.toMap(functions), bindings, typeContext, serializedFunctions);
    }

    @Deprecated(forRemoval=true, since="7")
    public SerializationContext(Map<String, ExpressionFunction> functions, Map<String, String> bindings, Map<String, String> serializedFunctions) {
        this(functions, bindings, Optional.empty(), serializedFunctions);
    }

    public SerializationContext(Map<String, ExpressionFunction> functions, Map<String, String> bindings, Optional<TypeContext<Reference>> typeContext, Map<String, String> serializedFunctions) {
        super(functions, bindings);
        this.typeContext = typeContext;
        this.serializedFunctions = serializedFunctions;
    }

    @Deprecated(forRemoval=true, since="7")
    public SerializationContext(ImmutableMap<String, ExpressionFunction> functions, Map<String, String> bindings, Map<String, String> serializedFunctions) {
        this((Map<String, ExpressionFunction>)functions, bindings, serializedFunctions);
    }

    public Optional<TypeContext<Reference>> typeContext() {
        return this.typeContext;
    }

    private static Map<String, ExpressionFunction> toMap(Collection<ExpressionFunction> list) {
        HashMap<String, ExpressionFunction> mapBuilder = new HashMap<String, ExpressionFunction>();
        for (ExpressionFunction function : list) {
            mapBuilder.put(function.getName(), function);
        }
        return Map.copyOf(mapBuilder);
    }

    public void addFunctionSerialization(String name, String expressionString) {
        this.serializedFunctions.put(name, expressionString);
    }

    public void addArgumentTypeSerialization(String functionName, String argumentName, TensorType type) {
        this.serializedFunctions.put("rankingExpression(" + functionName + ")." + argumentName + ".type", type.toString());
    }

    public void addFunctionTypeSerialization(String functionName, TensorType type) {
        if (type.rank() == 0) {
            return;
        }
        this.serializedFunctions.put("rankingExpression(" + functionName + ").type", type.toString());
    }

    @Override
    public SerializationContext withBindings(Map<String, String> bindings) {
        return new SerializationContext(this.getFunctions(), bindings, this.typeContext, this.serializedFunctions);
    }

    @Override
    public SerializationContext withoutBindings() {
        return new SerializationContext(this.getFunctions(), null, this.typeContext, this.serializedFunctions);
    }

    public Map<String, String> serializedFunctions() {
        return this.serializedFunctions;
    }

    public boolean needSerialization(String functionName) {
        return !this.serializedFunctions().containsKey(RankingExpression.propertyName(functionName));
    }
}

