/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.UnaryFunctionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class ZCurveFunctionNode
extends UnaryFunctionNode {
    public static final int classId = ZCurveFunctionNode.registerClass((int)16523, ZCurveFunctionNode.class);
    private Dimension dim = Dimension.X;

    public ZCurveFunctionNode() {
    }

    public ZCurveFunctionNode(ExpressionNode arg, Dimension dimension) {
        this.addArg(arg);
        this.dim = dimension;
    }

    public final Dimension getDimension() {
        return this.dim;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putByte(null, (byte)this.dim.id);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        byte b = buf.getByte(null);
        this.dim = Dimension.valueOf(b);
    }

    @Override
    protected boolean equalsUnaryFunction(UnaryFunctionNode obj) {
        return this.dim == ((ZCurveFunctionNode)obj).dim;
    }

    @Override
    public ZCurveFunctionNode clone() {
        ZCurveFunctionNode obj = (ZCurveFunctionNode)super.clone();
        obj.dim = this.dim;
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("dimension", (Object)this.dim);
    }

    public static enum Dimension {
        X(0),
        Y(1);

        private final int id;

        private Dimension(int id) {
            this.id = id;
        }

        private static Dimension valueOf(int id) {
            for (Dimension dim : Dimension.values()) {
                if (id != dim.id) continue;
                return dim;
            }
            return null;
        }
    }
}

