/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.transform;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import java.util.ArrayList;
import java.util.List;

public class ConstantDereferencer
extends ExpressionTransformer<TransformContext> {
    @Override
    public ExpressionNode transform(ExpressionNode node, TransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node, context);
        }
        return node;
    }

    private static boolean isSimpleFeature(Reference reference) {
        if (!reference.isSimple()) {
            return false;
        }
        String name = reference.name();
        return name.equals("attribute") || name.equals("constant") || name.equals("query");
    }

    private ExpressionNode transformFeature(ReferenceNode node, TransformContext context) {
        if (!node.getArguments().isEmpty() && !ConstantDereferencer.isSimpleFeature(node.reference())) {
            return this.transformArguments(node, context);
        }
        return this.transformConstantReference(node, context);
    }

    private ExpressionNode transformArguments(ReferenceNode node, TransformContext context) {
        List<ExpressionNode> arguments = node.getArguments().expressions();
        ArrayList<ExpressionNode> transformedArguments = new ArrayList<ExpressionNode>(arguments.size());
        for (ExpressionNode argument : arguments) {
            transformedArguments.add(this.transform(argument, context));
        }
        return node.setArguments(transformedArguments);
    }

    private ExpressionNode transformConstantReference(ReferenceNode node, TransformContext context) {
        Value value;
        ExpressionNode arg;
        String name = node.getName();
        if (node.reference().name().equals("constant") && (arg = node.getArguments().expressions().get(0)) instanceof ReferenceNode) {
            name = ((ReferenceNode)arg).getName();
        }
        if ((value = context.constants().get(name)) == null || value.type().rank() > 0) {
            return node;
        }
        return new ConstantNode(value.freeze());
    }
}

