/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression;

import com.yahoo.api.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParser;
import com.yahoo.searchlib.rankingexpression.parser.TokenMgrException;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Beta
public class FeatureList
implements Iterable<ReferenceNode> {
    private final List<ReferenceNode> features = new ArrayList<ReferenceNode>();

    public FeatureList(Reader reader) throws ParseException {
        this.features.addAll(FeatureList.parse(reader));
    }

    public FeatureList(String list) throws ParseException {
        this.features.addAll(FeatureList.parse(new StringReader(list)));
    }

    public FeatureList(File file) throws ParseException, FileNotFoundException {
        this.features.addAll(FeatureList.parse(new FileReader(file)));
    }

    private static List<ReferenceNode> parse(Reader reader) throws ParseException {
        List<ReferenceNode> lst;
        try {
            lst = new RankingExpressionParser(reader).featureList();
        }
        catch (TokenMgrException e) {
            ParseException t = new ParseException();
            throw (ParseException)t.initCause(e);
        }
        ArrayList<ReferenceNode> ret = new ArrayList<ReferenceNode>(lst.size());
        for (ReferenceNode obj : lst) {
            if (!(obj instanceof ReferenceNode)) {
                throw new IllegalStateException("Feature list contains a " + obj.getClass().getName() + ".");
            }
            ret.add(obj);
        }
        return ret;
    }

    public int size() {
        return this.features.size();
    }

    public ReferenceNode get(int i) {
        return this.features.get(i);
    }

    public int hashCode() {
        int ret = 0;
        for (ReferenceNode node : this.features) {
            ret += node.hashCode() * 17;
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureList)) {
            return false;
        }
        FeatureList lst = (FeatureList)obj;
        if (this.features.size() != lst.features.size()) {
            return false;
        }
        for (int i = 0; i < this.features.size(); ++i) {
            if (this.features.get(i).equals(lst.features.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (ReferenceNode node : this) {
            ret.append(node).append(" ");
        }
        return ret.toString();
    }

    @Override
    public Iterator<ReferenceNode> iterator() {
        return this.features.iterator();
    }
}

