/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.google.common.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;

@Beta
public class TensorValue
extends Value {
    private final Tensor value;

    public TensorValue(Tensor value) {
        this.value = value;
    }

    @Override
    public TensorType type() {
        return this.value.type();
    }

    @Override
    public double asDouble() {
        if (this.hasDouble()) {
            return this.value.get(TensorAddress.of((long[])new long[0]));
        }
        throw new UnsupportedOperationException("Requires a double value, but " + this.value + " cannot be used as a double");
    }

    @Override
    public boolean hasDouble() {
        return this.value.type().dimensions().isEmpty() && !this.value.isEmpty();
    }

    @Override
    public boolean asBoolean() {
        if (this.hasDouble()) {
            return this.asDouble() != 0.0;
        }
        throw new UnsupportedOperationException("Tensor does not have a value that can be converted to a boolean");
    }

    @Override
    public Value negate() {
        return new TensorValue(this.value.map(value -> -value));
    }

    @Override
    public Value add(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.add(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value + argument.asDouble()));
    }

    @Override
    public Value subtract(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.subtract(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value - argument.asDouble()));
    }

    @Override
    public Value multiply(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.multiply(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value * argument.asDouble()));
    }

    @Override
    public Value divide(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.divide(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value / argument.asDouble()));
    }

    @Override
    public Value modulo(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.fmod(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value % argument.asDouble()));
    }

    @Override
    public Value and(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.join(((TensorValue)argument).value, (a, b) -> a != 0.0 && b != 0.0 ? 1.0 : 0.0));
        }
        return new TensorValue(this.value.map(value -> value != 0.0 && argument.asBoolean() ? 1.0 : 0.0));
    }

    @Override
    public Value or(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.join(((TensorValue)argument).value, (a, b) -> a != 0.0 || b != 0.0 ? 1.0 : 0.0));
        }
        return new TensorValue(this.value.map(value -> value != 0.0 || argument.asBoolean() ? 1.0 : 0.0));
    }

    @Override
    public Value not() {
        return new TensorValue(this.value.map(value -> value == 0.0 ? 1.0 : 0.0));
    }

    @Override
    public Value power(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.pow(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> Math.pow(value, argument.asDouble())));
    }

    @Override
    public Tensor asTensor() {
        return this.value;
    }

    @Override
    public Value compare(TruthOperator operator, Value argument) {
        return new TensorValue(this.compareTensor(operator, argument.asTensor()));
    }

    private Tensor compareTensor(TruthOperator operator, Tensor argument) {
        switch (operator) {
            case LARGER: {
                return this.value.larger(argument);
            }
            case LARGEREQUAL: {
                return this.value.largerOrEqual(argument);
            }
            case SMALLER: {
                return this.value.smaller(argument);
            }
            case SMALLEREQUAL: {
                return this.value.smallerOrEqual(argument);
            }
            case EQUAL: {
                return this.value.equal(argument);
            }
            case NOTEQUAL: {
                return this.value.notEqual(argument);
            }
            case APPROX_EQUAL: {
                return this.value.approxEqual(argument);
            }
        }
        throw new UnsupportedOperationException("Tensors cannot be compared with " + operator);
    }

    @Override
    public Value function(Function function, Value arg) {
        if (arg instanceof TensorValue) {
            return new TensorValue(this.functionOnTensor(function, arg.asTensor()));
        }
        return new TensorValue(this.value.map(value -> function.evaluate(value, arg.asDouble())));
    }

    private Tensor functionOnTensor(Function function, Tensor argument) {
        switch (function) {
            case min: {
                return this.value.min(argument);
            }
            case max: {
                return this.value.max(argument);
            }
            case atan2: {
                return this.value.atan2(argument);
            }
            case pow: {
                return this.value.pow(argument);
            }
            case fmod: {
                return this.value.fmod(argument);
            }
            case ldexp: {
                return this.value.ldexp(argument);
            }
            case bit: {
                return this.value.bit(argument);
            }
            case hamming: {
                return this.value.hamming(argument);
            }
        }
        throw new UnsupportedOperationException("Cannot combine two tensors using " + function);
    }

    @Override
    public Value asMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorValue other = (TensorValue)o;
        return this.value.equals((Object)other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

