/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FunctionReferenceContext {
    private final ImmutableMap<String, ExpressionFunction> functions;
    private final Map<String, String> bindings = new HashMap<String, String>();

    public FunctionReferenceContext() {
        this(Collections.emptyList());
    }

    public FunctionReferenceContext(Collection<ExpressionFunction> functions) {
        this(FunctionReferenceContext.toMap(functions), Collections.emptyMap());
    }

    public FunctionReferenceContext(Collection<ExpressionFunction> functions, Map<String, String> bindings) {
        this(FunctionReferenceContext.toMap(functions), bindings);
    }

    public FunctionReferenceContext(Map<String, ExpressionFunction> functions) {
        this(functions, null);
    }

    public FunctionReferenceContext(Map<String, ExpressionFunction> functions, Map<String, String> bindings) {
        this((ImmutableMap<String, ExpressionFunction>)ImmutableMap.copyOf(functions), bindings);
    }

    protected FunctionReferenceContext(ImmutableMap<String, ExpressionFunction> functions, Map<String, String> bindings) {
        this.functions = functions;
        if (bindings != null) {
            this.bindings.putAll(bindings);
        }
    }

    private static ImmutableMap<String, ExpressionFunction> toMap(Collection<ExpressionFunction> list) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (ExpressionFunction function : list) {
            mapBuilder.put((Object)function.getName(), (Object)function);
        }
        return mapBuilder.build();
    }

    public ExpressionFunction getFunction(String name) {
        return (ExpressionFunction)this.functions.get((Object)name);
    }

    protected ImmutableMap<String, ExpressionFunction> functions() {
        return this.functions;
    }

    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    public FunctionReferenceContext withBindings(Map<String, String> bindings) {
        return new FunctionReferenceContext(this.functions, bindings);
    }

    public FunctionReferenceContext withoutBindings() {
        return new FunctionReferenceContext((Map<String, ExpressionFunction>)this.functions);
    }
}

