/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.AbstractArrayContext;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;

public class ArrayContext
extends AbstractArrayContext
implements Cloneable {
    private Value[] values = new Value[this.doubleValues().length];

    public ArrayContext(RankingExpression expression) {
        this(expression, false);
    }

    public ArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        this(expression, ignoreUnknownValues, defaultMissingValue);
    }

    public ArrayContext(RankingExpression expression, Value defaultValue) {
        this(expression, false, defaultValue);
    }

    public ArrayContext(RankingExpression expression, boolean ignoreUnknownValues, Value missingValue) {
        super(expression, ignoreUnknownValues, missingValue);
        Arrays.fill(this.values, this.missingValue);
    }

    @Override
    public final void put(String name, Value value) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            if (this.ignoreUnknownValues()) {
                return;
            }
            throw new IllegalArgumentException("Value '" + name + "' is not known to " + this);
        }
        this.put((int)index, value);
    }

    public final void put(int index, double value) {
        this.put(index, (Value)DoubleValue.frozen(value));
    }

    public final void put(int index, Value value) {
        this.values[index] = value.freeze();
        this.clearMissing(index);
        try {
            this.doubleValues()[index] = value.asDouble();
        }
        catch (UnsupportedOperationException e) {
            this.doubleValues()[index] = Double.NaN;
        }
    }

    public TensorType getType(Reference reference) {
        Integer index = this.nameToIndex().get(reference.toString());
        if (index == null) {
            return null;
        }
        return this.values[index].type();
    }

    @Override
    public Value get(String name) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            return this.missingValue;
        }
        return this.values[index];
    }

    @Override
    public final Value get(int index) {
        return this.values[index];
    }

    @Override
    public final double getDouble(int index) {
        double value = this.doubleValues()[index];
        if (Double.isNaN(value) && !this.isMissing(index)) {
            throw new UnsupportedOperationException("Value at " + index + " has no double representation");
        }
        return value;
    }

    @Override
    public ArrayContext clone() {
        ArrayContext clone = (ArrayContext)super.clone();
        clone.values = new Value[this.nameToIndex().size()];
        Arrays.fill(clone.values, this.missingValue);
        return clone;
    }
}

