/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class AggregationRefNode
extends ExpressionNode {
    public static final int classId = AggregationRefNode.registerClass((int)16526, AggregationRefNode.class);
    private AggregationResult result = null;
    private int index = -1;

    public AggregationRefNode() {
    }

    public AggregationRefNode(int index) {
        this.index = index;
    }

    public AggregationRefNode(AggregationResult result) {
        this.result = result;
    }

    public AggregationResult getExpression() {
        return this.result;
    }

    public AggregationRefNode setExpression(AggregationResult result) {
        this.result = result;
        return this;
    }

    public AggregationRefNode setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean onExecute() {
        return this.result.execute();
    }

    @Override
    public void onPrepare() {
        this.result.prepare();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.index);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.index = buf.getInt(null);
        this.result = null;
    }

    @Override
    public AggregationRefNode clone() {
        AggregationRefNode obj = (AggregationRefNode)super.clone();
        obj.index = this.index;
        obj.result = this.result.clone();
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("index", (Object)this.index);
    }

    @Override
    public ResultNode getResult() {
        return this.result.getResult();
    }

    public int hashCode() {
        return super.hashCode() + this.index;
    }

    @Override
    public boolean equalsExpression(ExpressionNode obj) {
        AggregationRefNode rhs = (AggregationRefNode)obj;
        if (this.index != rhs.index) {
            return false;
        }
        return AggregationRefNode.equals((Object)this.result, (Object)rhs.result);
    }
}

