/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class CountAggregationResult
extends AggregationResult {
    public static final int classId = CountAggregationResult.registerClass((int)16465, CountAggregationResult.class);
    private long count = 0L;

    public CountAggregationResult() {
    }

    public CountAggregationResult(long count) {
        this.setCount(count);
    }

    public final long getCount() {
        return this.count;
    }

    public final CountAggregationResult setCount(long count) {
        this.count = count;
        return this;
    }

    @Override
    public ResultNode getRank() {
        return new IntegerResultNode(this.count);
    }

    @Override
    protected void onMerge(AggregationResult result) {
        this.count += ((CountAggregationResult)result).count;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putLong(null, this.count);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.count = buf.getLong(null);
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        return this.count == ((CountAggregationResult)obj).count;
    }

    public int hashCode() {
        return super.hashCode() + (int)this.count;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("count", (Object)this.count);
    }
}

