/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableList;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import java.io.Serializable;
import java.util.List;

public final class Arguments
implements Serializable {
    private final ImmutableList<ExpressionNode> expressions;

    public Arguments() {
        this((List<? extends ExpressionNode>)ImmutableList.of());
    }

    public Arguments(ExpressionNode singleArgument) {
        this((List<? extends ExpressionNode>)ImmutableList.of((Object)singleArgument));
    }

    public Arguments(List<? extends ExpressionNode> expressions) {
        if (expressions == null) {
            this.expressions = ImmutableList.of();
            return;
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (ExpressionNode expressionNode : expressions) {
            b.add((Object)expressionNode);
        }
        this.expressions = b.build();
    }

    public List<ExpressionNode> expressions() {
        return this.expressions;
    }

    public int size() {
        return this.expressions.size();
    }

    public Value[] evaluate(Context context) {
        Value[] values = new Value[this.expressions.size()];
        for (int i = 0; i < this.expressions.size(); ++i) {
            values[i] = ((ExpressionNode)this.expressions.get(i)).evaluate(context);
        }
        return values;
    }

    public Value evaluate(int i, Context context) {
        return ((ExpressionNode)this.expressions.get(i)).evaluate(context);
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof Arguments && this.expressions.equals(((Arguments)other).expressions);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (ExpressionNode argument : this.expressions) {
            b.append(argument).append(",");
        }
        b.setLength(b.length() - 1);
        if (b.length() > 0) {
            b.append(")");
        }
        return b.toString();
    }
}

