/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.UnaryFunctionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class TimeStampFunctionNode
extends UnaryFunctionNode {
    public static final int classId = TimeStampFunctionNode.registerClass((int)16459, TimeStampFunctionNode.class);
    private TimePart timePart = TimePart.Year;
    private boolean isGmt = false;

    public TimeStampFunctionNode() {
    }

    public TimeStampFunctionNode(ExpressionNode arg, TimePart part, boolean gmt) {
        this.addArg(arg);
        this.timePart = part;
        this.isGmt = gmt;
    }

    public TimePart getTimePart() {
        return this.timePart;
    }

    public boolean isGmt() {
        return this.isGmt;
    }

    public boolean isLocal() {
        return !this.isGmt;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putByte(null, (byte)(this.timePart.id | (this.isGmt ? 128 : 0)));
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        byte b = buf.getByte(null);
        this.timePart = TimePart.valueOf(b & 0x7F);
        this.isGmt = (b & 0x80) != 0;
    }

    @Override
    protected boolean equalsUnaryFunction(UnaryFunctionNode obj) {
        TimeStampFunctionNode rhs = (TimeStampFunctionNode)obj;
        return this.timePart == rhs.timePart && this.isGmt == rhs.isGmt;
    }

    @Override
    public TimeStampFunctionNode clone() {
        TimeStampFunctionNode obj = (TimeStampFunctionNode)super.clone();
        obj.timePart = this.timePart;
        obj.isGmt = this.isGmt;
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("timepart", (Object)this.timePart);
        visitor.visit("islocal", (Object)this.isGmt);
    }

    public static enum TimePart {
        Year(0),
        Month(1),
        MonthDay(2),
        WeekDay(3),
        Hour(4),
        Minute(5),
        Second(6),
        YearDay(7),
        IsDST(8);

        private final int id;

        private TimePart(int id) {
            this.id = id;
        }

        private static TimePart valueOf(int id) {
            for (TimePart part : TimePart.values()) {
                if (id != part.id) continue;
                return part;
            }
            return null;
        }
    }
}

