/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.rule.FunctionReferenceContext;
import com.yahoo.tensor.TensorType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SerializationContext
extends FunctionReferenceContext {
    private final Map<String, String> serializedFunctions;

    public SerializationContext() {
        this(Collections.emptyList());
    }

    public SerializationContext(Collection<ExpressionFunction> functions) {
        this(functions, Collections.emptyMap(), new LinkedHashMap<String, String>());
    }

    public SerializationContext(Map<String, ExpressionFunction> functions) {
        this(functions.values());
    }

    public SerializationContext(Collection<ExpressionFunction> functions, Map<String, String> bindings) {
        this(functions, bindings, new LinkedHashMap<String, String>());
    }

    public SerializationContext(Collection<ExpressionFunction> functions, Map<String, String> bindings, Map<String, String> serializedFunctions) {
        this(SerializationContext.toMap(functions), bindings, serializedFunctions);
    }

    private static ImmutableMap<String, ExpressionFunction> toMap(Collection<ExpressionFunction> list) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (ExpressionFunction function : list) {
            mapBuilder.put((Object)function.getName(), (Object)function);
        }
        return mapBuilder.build();
    }

    public SerializationContext(ImmutableMap<String, ExpressionFunction> functions, Map<String, String> bindings, Map<String, String> serializedFunctions) {
        super((Map<String, ExpressionFunction>)functions, bindings);
        this.serializedFunctions = serializedFunctions;
    }

    public void addFunctionSerialization(String name, String expressionString) {
        this.serializedFunctions.put(name, expressionString);
    }

    public void addArgumentTypeSerialization(String functionName, String argumentName, TensorType type) {
        this.serializedFunctions.put("rankingExpression(" + functionName + ")." + argumentName + ".type", type.toString());
    }

    public void addFunctionTypeSerialization(String functionName, TensorType type) {
        if (type.rank() == 0) {
            return;
        }
        this.serializedFunctions.put("rankingExpression(" + functionName + ").type", type.toString());
    }

    @Override
    public SerializationContext withBindings(Map<String, String> bindings) {
        return new SerializationContext(this.functions(), bindings, this.serializedFunctions);
    }

    @Override
    public SerializationContext withoutBindings() {
        return new SerializationContext(this.functions(), null, this.serializedFunctions);
    }

    public Map<String, String> serializedFunctions() {
        return this.serializedFunctions;
    }

    public boolean needSerialization(String functionName) {
        return !this.serializedFunctions().containsKey(RankingExpression.propertyName(functionName));
    }
}

