/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ArithmeticTypeConversion;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FunctionNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.List;

public abstract class MultiArgFunctionNode
extends FunctionNode {
    public static final int classId = MultiArgFunctionNode.registerClass((int)16429, MultiArgFunctionNode.class);
    private List<ExpressionNode> args = new ArrayList<ExpressionNode>();

    public MultiArgFunctionNode addArg(ExpressionNode arg) {
        arg.getClass();
        this.args.add(arg);
        return this;
    }

    public ExpressionNode getArg(int i) {
        return this.args.get(i);
    }

    public int getNumArgs() {
        return this.args.size();
    }

    @Override
    protected boolean onExecute() {
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.get(i).execute();
        }
        return this.calculate(this.args, this.getResult());
    }

    @Override
    protected void onPrepare() {
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.get(i).prepare();
        }
        this.prepareResult();
    }

    private boolean calculate(List<ExpressionNode> args, ResultNode result) {
        return this.onCalculate(args, result);
    }

    private void prepareResult() {
        this.onPrepareResult();
    }

    protected boolean onCalculate(List<ExpressionNode> args, ResultNode result) {
        result.set(args.get(0).getResult());
        for (int i = 1; i < args.size(); ++i) {
            this.executeIterative(args.get(i).getResult(), result);
        }
        return true;
    }

    protected void onPrepareResult() {
        if (this.args.size() == 1) {
            this.setResult(ArithmeticTypeConversion.getType(this.args.get(0).getResult()));
        } else if (this.args.size() > 1) {
            this.setResult((ResultNode)this.args.get(0).getResult().clone());
            for (int i = 1; i < this.args.size(); ++i) {
                if (this.args.get(i).getResult() == null) continue;
                this.setResult(ArithmeticTypeConversion.getType(this.getResult(), this.args.get(i).getResult()));
            }
        }
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        int numArgs = this.args.size();
        buf.putInt(null, numArgs);
        for (ExpressionNode node : this.args) {
            MultiArgFunctionNode.serializeOptional((Serializer)buf, (Identifiable)node);
        }
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.args.clear();
        int numArgs = buf.getInt(null);
        for (int i = 0; i < numArgs; ++i) {
            ExpressionNode node = (ExpressionNode)MultiArgFunctionNode.deserializeOptional((Deserializer)buf);
            this.args.add(node);
        }
    }

    public int hashCode() {
        int ret = super.hashCode();
        for (ExpressionNode node : this.args) {
            ret += node.hashCode();
        }
        return ret;
    }

    @Override
    protected final boolean equalsFunction(FunctionNode obj) {
        MultiArgFunctionNode rhs = (MultiArgFunctionNode)obj;
        if (!this.args.equals(rhs.args)) {
            return false;
        }
        return this.equalsMultiArgFunction(rhs);
    }

    protected abstract boolean equalsMultiArgFunction(MultiArgFunctionNode var1);

    @Override
    public MultiArgFunctionNode clone() {
        MultiArgFunctionNode obj = (MultiArgFunctionNode)super.clone();
        obj.args = new ArrayList<ExpressionNode>();
        for (ExpressionNode node : this.args) {
            obj.args.add(node.clone());
        }
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("args", this.args);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        super.selectMembers(predicate, operation);
        for (ExpressionNode arg : this.args) {
            arg.select(predicate, operation);
        }
    }
}

