/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.transform;

import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticNode;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.ComparisonNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.IfNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import java.util.ArrayList;
import java.util.List;

public class Simplifier
extends ExpressionTransformer<TransformContext> {
    @Override
    public ExpressionNode transform(ExpressionNode node, TransformContext context) {
        if (node instanceof CompositeNode) {
            node = this.transformChildren((CompositeNode)node, context);
        }
        if (node instanceof IfNode) {
            node = this.transformIf((IfNode)node);
        }
        if (node instanceof EmbracedNode && this.hasSingleUndividableChild((EmbracedNode)node)) {
            node = ((EmbracedNode)node).children().get(0);
        }
        if (node instanceof ArithmeticNode) {
            node = this.transformArithmetic((ArithmeticNode)node);
        }
        return node;
    }

    private boolean hasSingleUndividableChild(EmbracedNode node) {
        if (node.children().size() > 1) {
            return false;
        }
        if (node.children().get(0) instanceof ArithmeticNode) {
            return false;
        }
        return !(node.children().get(0) instanceof ComparisonNode);
    }

    private ExpressionNode transformArithmetic(ArithmeticNode node) {
        if (node.children().size() > 1) {
            ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>(node.children());
            ArrayList<ArithmeticOperator> operators = new ArrayList<ArithmeticOperator>(node.operators());
            for (ArithmeticOperator operator : ArithmeticOperator.operatorsByPrecedence) {
                this.transform(operator, children, operators);
            }
            node = new ArithmeticNode(children, operators);
        }
        if (this.isConstant(node) && !node.evaluate(null).isNaN()) {
            return new ConstantNode(node.evaluate(null));
        }
        if (this.allMultiplicationOrDivision(node) && this.hasZero(node) && !this.hasDivisionByZero(node)) {
            return new ConstantNode(new DoubleValue(0.0));
        }
        return node;
    }

    private void transform(ArithmeticOperator operatorToTransform, List<ExpressionNode> children, List<ArithmeticOperator> operators) {
        int i = 0;
        while (i < children.size() - 1) {
            boolean transformed = false;
            if (operators.get(i).equals((Object)operatorToTransform)) {
                Value evaluated;
                ExpressionNode child1 = children.get(i);
                ExpressionNode child2 = children.get(i + 1);
                if (this.isConstant(child1) && this.isConstant(child2) && this.hasPrecedence(operators, i) && !(evaluated = new ArithmeticNode(child1, operators.get(i), child2).evaluate(null)).isNaN()) {
                    operators.remove(i);
                    children.set(i, new ConstantNode(evaluated.freeze()));
                    children.remove(i + 1);
                    transformed = true;
                }
            }
            if (transformed) continue;
            ++i;
        }
    }

    private boolean hasPrecedence(List<ArithmeticOperator> operators, int i) {
        if (i > 0 && operators.get(i - 1).hasPrecedenceOver(operators.get(i))) {
            return false;
        }
        return i >= operators.size() - 1 || !operators.get(i + 1).hasPrecedenceOver(operators.get(i));
    }

    private ExpressionNode transformIf(IfNode node) {
        if (!this.isConstant(node.getCondition())) {
            return node;
        }
        if (node.getCondition().evaluate(null).asBoolean()) {
            return node.getTrueExpression();
        }
        return node.getFalseExpression();
    }

    private boolean allMultiplicationOrDivision(ArithmeticNode node) {
        for (ArithmeticOperator o : node.operators()) {
            if (o == ArithmeticOperator.MULTIPLY || o == ArithmeticOperator.DIVIDE) continue;
            return false;
        }
        return true;
    }

    private boolean hasZero(ArithmeticNode node) {
        for (ExpressionNode child : node.children()) {
            if (!this.isZero(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDivisionByZero(ArithmeticNode node) {
        for (int i = 1; i < node.children().size(); ++i) {
            if (node.operators().get(i - 1) != ArithmeticOperator.DIVIDE || !this.isZero(node.children().get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isZero(ExpressionNode node) {
        if (!(node instanceof ConstantNode)) {
            return false;
        }
        ConstantNode constant = (ConstantNode)node;
        if (!constant.getValue().hasDouble()) {
            return false;
        }
        return constant.getValue().asDouble() == 0.0;
    }

    private boolean isConstant(ExpressionNode node) {
        if (node instanceof ConstantNode) {
            return true;
        }
        if (node instanceof ReferenceNode) {
            return false;
        }
        if (node instanceof TensorFunctionNode) {
            return false;
        }
        if (!(node instanceof CompositeNode)) {
            return false;
        }
        for (ExpressionNode child : ((CompositeNode)node).children()) {
            if (this.isConstant(child)) continue;
            return false;
        }
        return true;
    }
}

