/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.AbstractArrayContext;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.TensorType;

public class DoubleOnlyArrayContext
extends AbstractArrayContext {
    public DoubleOnlyArrayContext(RankingExpression expression) {
        this(expression, false, defaultMissingValue);
    }

    public DoubleOnlyArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        this(expression, ignoreUnknownValues, defaultMissingValue);
    }

    public DoubleOnlyArrayContext(RankingExpression expression, boolean ignoreUnknownValues, Value missingValue) {
        super(expression, ignoreUnknownValues, missingValue);
    }

    @Override
    public final void put(String name, Value value) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            if (this.ignoreUnknownValues()) {
                return;
            }
            throw new IllegalArgumentException("Value '" + name + "' is not known to " + this);
        }
        this.put((int)index, value);
    }

    public final void put(int index, double value) {
        this.doubleValues()[index] = value;
        this.clearMissing(index);
    }

    public final void put(int index, Value value) {
        try {
            this.put(index, value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("This context only supports doubles, not " + value);
        }
    }

    public TensorType getType(Reference reference) {
        return TensorType.empty;
    }

    @Override
    public Value get(String name) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            return this.missingValue;
        }
        return new DoubleValue(this.getDouble(index));
    }

    @Override
    public final Value get(int index) {
        return new DoubleValue(this.getDouble(index));
    }

    @Override
    public DoubleOnlyArrayContext clone() {
        return (DoubleOnlyArrayContext)super.clone();
    }
}

