/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.PositiveInfinityResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.SingleResultNode;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class StringResultNode
extends SingleResultNode {
    public static final int classId = StringResultNode.registerClass((int)16437, StringResultNode.class);
    private static StringResultNode negativeInfinity = new StringResultNode("");
    private static PositiveInfinityResultNode positiveInfinity = new PositiveInfinityResultNode();
    private String value;

    public StringResultNode() {
        this.value = "";
    }

    public StringResultNode(String value) {
        this.setValue(value);
    }

    public StringResultNode setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can not be null.");
        }
        this.value = value;
        return this;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        byte[] raw = this.getRaw();
        buf.putInt(null, raw.length);
        buf.put(null, raw);
    }

    protected void onDeserialize(Deserializer buf) {
        this.value = this.getUtf8(buf);
    }

    @Override
    public long getInteger() {
        try {
            return Integer.valueOf(this.value).intValue();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double getFloat() {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public byte[] getRaw() {
        return Utf8.toBytes((String)this.value);
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        return rhs instanceof PositiveInfinityResultNode ? -1 : this.value.compareTo(rhs.getString());
    }

    public int hashCode() {
        return super.hashCode() + this.value.hashCode();
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.value);
    }

    @Override
    public void add(ResultNode rhs) {
        this.value = this.value + rhs.getString();
    }

    @Override
    public void min(ResultNode rhs) {
        if (this.value.compareTo(rhs.getString()) > 0) {
            this.value = rhs.getString();
        }
    }

    @Override
    public void max(ResultNode rhs) {
        if (this.value.compareTo(rhs.getString()) < 0) {
            this.value = rhs.getString();
        }
    }

    public void append(ResultNode rhs) {
        this.value = this.value + rhs.getString();
    }

    @Override
    public Object getValue() {
        return this.getString();
    }

    @Override
    public void set(ResultNode rhs) {
        this.value = rhs.getString();
    }

    @Override
    public void negate() {
        char[] a = this.value.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = -a[i];
        }
        this.value = new String(a);
    }

    public static StringResultNode getNegativeInfinity() {
        return negativeInfinity;
    }

    public static PositiveInfinityResultNode getPositiveInfinity() {
        return positiveInfinity;
    }
}

