/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

import com.yahoo.searchlib.ranking.features.fieldmatch.QueryTerm;
import java.util.Arrays;

public class Query {
    private QueryTerm[] terms;
    private int totalTermWeight = 0;
    private float totalSignificance = 0.0f;

    public Query(String query) {
        this(Query.splitQuery(query));
    }

    public Query(QueryTerm[] terms) {
        this.terms = terms;
        for (QueryTerm term : terms) {
            this.totalTermWeight += term.getWeight();
            this.totalSignificance += term.getSignificance();
        }
    }

    private static QueryTerm[] splitQuery(String queryString) {
        String[] queryTerms = queryString.split(" ");
        QueryTerm[] query = new QueryTerm[queryTerms.length];
        for (int i = 0; i < query.length; ++i) {
            query[i] = new QueryTerm(queryTerms[i]);
        }
        return query;
    }

    public QueryTerm[] getTerms() {
        return this.terms;
    }

    public int getTotalTermWeight() {
        return this.totalTermWeight;
    }

    public void setTotalTermWeight(int totalTermWeight) {
        this.totalTermWeight = totalTermWeight;
    }

    public float getTotalSignificance() {
        return this.totalSignificance;
    }

    public void setTotalSignificance(float totalSignificance) {
        this.totalSignificance = totalSignificance;
    }

    public String toString() {
        return "query: " + Arrays.toString(this.terms);
    }
}

