/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

public final class FieldMatchMetricsParameters {
    private boolean frozen = false;
    private int proximityLimit = 10;
    private int maxAlternativeSegmentations = 10000;
    private int maxOccurrences = 100;
    private float proximityCompletenessImportance = 0.9f;
    private float relatednessImportance = 0.9f;
    private float earlinessImportance = 0.05f;
    private float segmentProximityImportance = 0.05f;
    private float occurrenceImportance = 0.05f;
    private float fieldCompletenessImportance = 0.05f;
    private float[] proximityTable = new float[]{0.01f, 0.02f, 0.03f, 0.04f, 0.06f, 0.08f, 0.12f, 0.17f, 0.24f, 0.33f, 1.0f, 0.71f, 0.5f, 0.35f, 0.25f, 0.18f, 0.13f, 0.09f, 0.06f, 0.04f, 0.03f};
    private static FieldMatchMetricsParameters defaultParameters = new FieldMatchMetricsParameters();

    public static FieldMatchMetricsParameters defaultParameters() {
        return defaultParameters;
    }

    public void setProximityLimit(int proximityLimit) {
        this.ensureNotFrozen();
        this.proximityLimit = proximityLimit;
    }

    public int getProximityLimit() {
        return this.proximityLimit;
    }

    public void setProximityTable(float[] proximityTable) {
        this.ensureNotFrozen();
        this.proximityTable = proximityTable;
    }

    public float[] getProximityTable() {
        return this.proximityTable;
    }

    public float getProximity(int index) {
        return this.proximityTable[index];
    }

    public int getMaxAlternativeSegmentations() {
        return this.maxAlternativeSegmentations;
    }

    public void setMaxAlternativeSegmentations(int maxAlternativeSegmentations) {
        this.ensureNotFrozen();
        this.maxAlternativeSegmentations = maxAlternativeSegmentations;
    }

    public int getMaxOccurrences() {
        return this.maxOccurrences;
    }

    public void setMaxOccurrences(int maxOccurrences) {
        this.maxOccurrences = maxOccurrences;
    }

    public float getFieldCompletenessImportance() {
        return this.fieldCompletenessImportance;
    }

    public void setFieldCompletenessImportance(float fieldCompletenessImportance) {
        this.ensureNotFrozen();
        this.fieldCompletenessImportance = fieldCompletenessImportance;
    }

    public float getProximityCompletenessImportance() {
        return this.proximityCompletenessImportance;
    }

    public void setProximityCompletenessImportance(float proximityCompletenessImportance) {
        this.ensureNotFrozen();
        this.proximityCompletenessImportance = proximityCompletenessImportance;
    }

    public float getEarlinessImportance() {
        return this.earlinessImportance;
    }

    public void setEarlinessImportance(float earlinessImportance) {
        this.ensureNotFrozen();
        this.earlinessImportance = earlinessImportance;
    }

    public float getSegmentProximityImportance() {
        return this.segmentProximityImportance;
    }

    public void setSegmentProximityImportance(float segmentProximityImportance) {
        this.ensureNotFrozen();
        this.segmentProximityImportance = segmentProximityImportance;
    }

    public float getOccurrenceImportance() {
        return this.occurrenceImportance;
    }

    public void setOccurrenceImportance(float occurrenceImportance) {
        this.ensureNotFrozen();
        this.occurrenceImportance = occurrenceImportance;
    }

    public float getRelatednessImportance() {
        return this.relatednessImportance;
    }

    public void setRelatednessImportance(float relatednessImportance) {
        this.ensureNotFrozen();
        this.relatednessImportance = relatednessImportance;
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException(this + " is frozen");
        }
    }

    public void freeze() {
        if (this.proximityTable.length != this.proximityLimit * 2 + 1) {
            throw new IllegalStateException("Proximity table length is " + this.proximityTable.length + ". Must be " + (this.proximityLimit * 2 + 1) + " (proximityLimit*2+1), because the proximity limit is " + this.proximityLimit);
        }
        this.frozen = true;
    }

    static {
        defaultParameters.freeze();
    }
}

