/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.Deque;

public final class GBDTNode
extends ExpressionNode {
    public static final int MAX_LEAF_VALUE = 2000000000;
    public static final int MAX_VARIABLES = 1000000;
    private final double[] values;

    public GBDTNode(double[] values) {
        this.values = values;
    }

    public final double[] values() {
        return this.values;
    }

    @Override
    public final TensorType type(TypeContext<Reference> context) {
        return TensorType.empty;
    }

    @Override
    public final Value evaluate(Context context) {
        return new DoubleValue(GBDTNode.evaluate(this.values, 0, context));
    }

    public static double evaluate(double[] values, int startOffset, Context context) {
        double nextValue;
        int pc = startOffset;
        while (true) {
            int n = pc++;
            nextValue = values[n];
            if (!(nextValue >= 2.0E9)) break;
            int offset = (int)nextValue - 2000000000;
            boolean comparisonIsTrue = false;
            if (offset < 1000000) {
                comparisonIsTrue = context.getDouble(offset) < values[pc++];
            } else if (offset < 2000000) {
                comparisonIsTrue = context.getDouble(offset - 1000000) == values[pc++];
            } else if (offset < 3000000) {
                int setValuesLeft;
                double testValue = context.getDouble(offset - 2000000);
                for (setValuesLeft = (int)values[pc++]; setValuesLeft > 0; --setValuesLeft) {
                    if (testValue != values[pc++]) continue;
                    comparisonIsTrue = true;
                    break;
                }
                pc += setValuesLeft;
            } else {
                boolean bl = comparisonIsTrue = !(context.getDouble(offset - 3000000) >= values[pc++]);
            }
            if (comparisonIsTrue) {
                ++pc;
                continue;
            }
            pc = (int)((double)pc + values[pc]);
        }
        return nextValue;
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        return string.append("(optimized condition tree)");
    }
}

