/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression;

import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.NameNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.evaluation.Name;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;

public class Reference
extends Name {
    private final int hashCode;
    private final Arguments arguments;
    private final String output;
    private final boolean isIdentifier;

    public static Reference fromIdentifier(String identifier) {
        return new Reference(identifier, new Arguments(), null, true);
    }

    public Reference(String name, Arguments arguments, String output) {
        this(name, arguments, output, false);
    }

    private Reference(String name, Arguments arguments, String output, boolean isIdentifier) {
        super(name);
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(arguments, "arguments cannot be null");
        this.arguments = arguments;
        this.output = output;
        this.hashCode = Objects.hash(this.name(), arguments, output, isIdentifier);
        this.isIdentifier = isIdentifier;
    }

    public Arguments arguments() {
        return this.arguments;
    }

    public String output() {
        return this.output;
    }

    public static Reference simple(String name, String argumentValue) {
        return new Reference(name, new Arguments(new ReferenceNode(argumentValue)), null);
    }

    public static Optional<Reference> simple(String feature) {
        int startParenthesis = feature.indexOf(40);
        if (startParenthesis < 0) {
            return Optional.empty();
        }
        int endParenthesis = feature.lastIndexOf(41);
        String featureName = feature.substring(0, startParenthesis);
        if (startParenthesis < 1 || endParenthesis < startParenthesis) {
            return Optional.empty();
        }
        String argument = feature.substring(startParenthesis + 1, endParenthesis);
        if (argument.startsWith("'") || argument.startsWith("\"")) {
            argument = argument.substring(1);
        }
        if (argument.endsWith("'") || argument.endsWith("\"")) {
            argument = argument.substring(0, argument.length() - 1);
        }
        return Optional.of(Reference.simple(featureName, argument));
    }

    public boolean isIdentifier() {
        return this.isIdentifier;
    }

    public boolean isSimple() {
        return this.simpleArgument().isPresent();
    }

    public Optional<String> simpleArgument() {
        if (this.arguments.expressions().size() != 1) {
            return Optional.empty();
        }
        ExpressionNode argument = this.arguments.expressions().get(0);
        if (argument instanceof ReferenceNode) {
            ReferenceNode refArgument = (ReferenceNode)argument;
            if (!refArgument.reference().isIdentifier()) {
                return Optional.empty();
            }
            return Optional.of(refArgument.getName());
        }
        if (argument instanceof NameNode) {
            return Optional.of(((NameNode)argument).getValue());
        }
        return Optional.empty();
    }

    public Reference withArguments(Arguments arguments) {
        return new Reference(this.name(), arguments, this.output, this.isIdentifier && arguments.isEmpty());
    }

    public Reference withOutput(String output) {
        return new Reference(this.name(), this.arguments, output, this.isIdentifier && output == null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)((Object)o);
        if (!Objects.equals(other.name(), this.name())) {
            return false;
        }
        if (!Objects.equals(other.arguments, this.arguments)) {
            return false;
        }
        if (!Objects.equals(other.output, this.output)) {
            return false;
        }
        return Objects.equals(other.isIdentifier, this.isIdentifier);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString(new StringBuilder(), new SerializationContext(), null, null).toString();
    }

    public StringBuilder toString(StringBuilder b, SerializationContext context, Deque<String> path, CompositeNode parent) {
        b.append(this.name());
        if (this.arguments.expressions().size() > 0) {
            b.append("(");
            for (int i = 0; i < this.arguments.expressions().size(); ++i) {
                ExpressionNode e = this.arguments.expressions().get(i);
                e.toString(b, context, path, parent);
                if (i + 1 >= this.arguments.expressions().size()) continue;
                b.append(',');
            }
            b.append(")");
        }
        if (this.output != null) {
            b.append(".").append(this.output);
        }
        return b;
    }
}

