/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Context
implements EvaluationContext<Reference> {
    static Value defaultMissingValue = DoubleValue.zero;
    Value missingValue;

    public abstract Value get(String var1);

    public TensorType getType(String reference) {
        throw new UnsupportedOperationException("Not able to parse gereral references from string form");
    }

    public Tensor getTensor(String name) {
        return this.get(name).asTensor();
    }

    public Value get(String name, Arguments arguments, String output) {
        if (arguments != null && arguments.expressions().size() > 0) {
            name = (String)name + "(" + arguments.expressions().stream().map(ExpressionNode::toString).collect(Collectors.joining(",")) + ")";
        }
        if (output != null) {
            name = (String)name + "." + output;
        }
        return this.get((String)name);
    }

    public Value get(int index) {
        throw new UnsupportedOperationException(this + " does not support variable lookup by index");
    }

    public double getDouble(int index) {
        throw new UnsupportedOperationException(this + " does not support variable lookup by index");
    }

    public final void put(String name, double value) {
        this.put(name, DoubleValue.frozen(value));
    }

    public void put(String name, Value value) {
        throw new UnsupportedOperationException(this + " does not support variable assignment");
    }

    public Set<String> names() {
        throw new UnsupportedOperationException(this + " does not support return a list of its names");
    }
}

