/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml.importer.xgboost;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.xgboost.XGBoostTree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class XGBoostParser {
    private List<XGBoostTree> xgboostTrees = new ArrayList<XGBoostTree>();

    public XGBoostParser(String filePath) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode forestNode = mapper.readTree(new File(filePath));
        for (JsonNode treeNode : forestNode) {
            this.xgboostTrees.add((XGBoostTree)mapper.treeToValue((TreeNode)treeNode, XGBoostTree.class));
        }
    }

    public String toRankingExpression() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.xgboostTrees.size(); ++i) {
            ret.append(this.treeToRankExp(this.xgboostTrees.get(i)));
            if (i == this.xgboostTrees.size() - 1) continue;
            ret.append(" + \n");
        }
        return ret.toString();
    }

    public String treeToRankExp(XGBoostTree node) {
        String falseExp;
        String trueExp;
        if (node.isLeaf()) {
            return Double.toString(node.getLeaf());
        }
        assert (node.getChildren().size() == 2);
        if (node.getYes() == node.getChildren().get(0).getNodeid()) {
            trueExp = this.treeToRankExp(node.getChildren().get(0));
            falseExp = this.treeToRankExp(node.getChildren().get(1));
        } else {
            trueExp = this.treeToRankExp(node.getChildren().get(1));
            falseExp = this.treeToRankExp(node.getChildren().get(0));
        }
        return "if (" + node.getSplit() + " < " + Double.toString(node.getSplit_condition()) + ", " + trueExp + ", " + falseExp + ")";
    }
}

