/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.path.Path;
import com.yahoo.searchlib.rankingexpression.integration.ml.ImportedModel;
import com.yahoo.searchlib.rankingexpression.integration.ml.ModelImporter;
import com.yahoo.searchlib.rankingexpression.integration.ml.OnnxImporter;
import com.yahoo.searchlib.rankingexpression.integration.ml.TensorFlowImporter;
import com.yahoo.searchlib.rankingexpression.integration.ml.XGBoostImporter;
import java.io.File;
import java.util.Collection;
import java.util.Optional;

public class ImportedModels {
    private final ImmutableMap<String, ImportedModel> importedModels;
    private static final ImmutableList<ModelImporter> importers = ImmutableList.of((Object)new TensorFlowImporter(), (Object)new OnnxImporter(), (Object)new XGBoostImporter());

    public ImportedModels() {
        this.importedModels = ImmutableMap.of();
    }

    public ImportedModels(File modelsDirectory) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        ImportedModels.importRecursively(modelsDirectory, (ImmutableMap.Builder<String, ImportedModel>)builder);
        this.importedModels = builder.build();
    }

    private static void importRecursively(File dir, ImmutableMap.Builder<String, ImportedModel> builder) {
        if (!dir.isDirectory()) {
            return;
        }
        for (File child : dir.listFiles()) {
            Optional<ModelImporter> importer = ImportedModels.findImporterOf(child);
            if (importer.isPresent()) {
                String name = ImportedModels.toName(child);
                builder.put((Object)name, (Object)importer.get().importModel(name, child));
                continue;
            }
            ImportedModels.importRecursively(child, builder);
        }
    }

    private static Optional<ModelImporter> findImporterOf(File path) {
        return importers.stream().filter(item -> item.canImport(path.toString())).findFirst();
    }

    public ImportedModel get(File modelPath) {
        return (ImportedModel)this.importedModels.get((Object)ImportedModels.toName(modelPath));
    }

    public ImportedModel get(String modelName) {
        return (ImportedModel)this.importedModels.get((Object)modelName);
    }

    public Collection<ImportedModel> all() {
        return this.importedModels.values();
    }

    private static String toName(File modelFile) {
        Path modelPath = Path.fromString((String)modelFile.toString());
        if (modelFile.isFile()) {
            modelPath = ImportedModels.stripFileEnding(modelPath);
        }
        String localPath = ImportedModels.concatenateAfterModelsDirectory(modelPath);
        return localPath.replace('.', '_');
    }

    private static Path stripFileEnding(Path path) {
        int dotIndex = path.last().lastIndexOf(".");
        if (dotIndex <= 0) {
            return path;
        }
        return path.withLast(path.last().substring(0, dotIndex));
    }

    private static String concatenateAfterModelsDirectory(Path path) {
        boolean afterModels = false;
        StringBuilder result = new StringBuilder();
        for (String element : path.elements()) {
            if (afterModels) {
                result.append(element).append("_");
            }
            if (!element.equals("models")) continue;
            afterModels = true;
        }
        return result.substring(0, result.length() - 1);
    }
}

