/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml;

import com.yahoo.collections.Pair;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ImportedModel {
    private static final String defaultSignatureName = "default";
    private static final Pattern nameRegexp = Pattern.compile("[A-Za-z0-9_]*");
    private final String name;
    private final Map<String, Signature> signatures = new HashMap<String, Signature>();
    private final Map<String, TensorType> arguments = new HashMap<String, TensorType>();
    private final Map<String, Tensor> smallConstants = new HashMap<String, Tensor>();
    private final Map<String, Tensor> largeConstants = new HashMap<String, Tensor>();
    private final Map<String, RankingExpression> expressions = new HashMap<String, RankingExpression>();
    private final Map<String, RankingExpression> macros = new HashMap<String, RankingExpression>();
    private final Map<String, TensorType> requiredMacros = new HashMap<String, TensorType>();

    public ImportedModel(String name) {
        if (!nameRegexp.matcher(name).matches()) {
            throw new IllegalArgumentException("An imported model name can only contain [A-Za-z0-9_], but is '" + name + "'");
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Map<String, TensorType> arguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public Map<String, Tensor> smallConstants() {
        return Collections.unmodifiableMap(this.smallConstants);
    }

    public Map<String, Tensor> largeConstants() {
        return Collections.unmodifiableMap(this.largeConstants);
    }

    public Map<String, RankingExpression> expressions() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public Map<String, RankingExpression> macros() {
        return Collections.unmodifiableMap(this.macros);
    }

    public Map<String, TensorType> requiredMacros() {
        return Collections.unmodifiableMap(this.requiredMacros);
    }

    public Map<String, Signature> signatures() {
        return Collections.unmodifiableMap(this.signatures);
    }

    Signature signature(String name) {
        return this.signatures.computeIfAbsent(name, x$0 -> new Signature((String)x$0));
    }

    Signature defaultSignature() {
        return this.signature(defaultSignatureName);
    }

    void argument(String name, TensorType argumentType) {
        this.arguments.put(name, argumentType);
    }

    void smallConstant(String name, Tensor constant) {
        this.smallConstants.put(name, constant);
    }

    void largeConstant(String name, Tensor constant) {
        this.largeConstants.put(name, constant);
    }

    void expression(String name, RankingExpression expression) {
        this.expressions.put(name, expression);
    }

    void macro(String name, RankingExpression expression) {
        this.macros.put(name, expression);
    }

    void requiredMacro(String name, TensorType type) {
        this.requiredMacros.put(name, type);
    }

    public List<Pair<String, RankingExpression>> outputExpressions() {
        ArrayList<Pair<String, RankingExpression>> expressions = new ArrayList<Pair<String, RankingExpression>>();
        for (Map.Entry<String, Signature> entry : this.signatures().entrySet()) {
            for (Map.Entry<String, String> outputEntry : entry.getValue().outputs().entrySet()) {
                expressions.add((Pair<String, RankingExpression>)new Pair((Object)(entry.getKey() + "." + outputEntry.getKey()), (Object)this.expressions().get(outputEntry.getValue())));
            }
            if (!entry.getValue().outputs().isEmpty()) continue;
            expressions.add((Pair<String, RankingExpression>)new Pair((Object)entry.getKey(), (Object)this.expressions().get(entry.getKey())));
        }
        if (this.signatures().isEmpty()) {
            if (this.expressions().size() == 1) {
                Map.Entry<String, RankingExpression> singleEntry = this.expressions.entrySet().iterator().next();
                expressions.add((Pair<String, RankingExpression>)new Pair((Object)singleEntry.getKey(), (Object)singleEntry.getValue()));
            } else {
                for (Map.Entry<String, Object> entry : this.expressions().entrySet()) {
                    expressions.add((Pair<String, RankingExpression>)new Pair((Object)entry.getKey(), entry.getValue()));
                }
            }
        }
        return expressions;
    }

    public class Signature {
        private final String name;
        private final Map<String, String> inputs = new HashMap<String, String>();
        private final Map<String, String> outputs = new HashMap<String, String>();
        private final Map<String, String> skippedOutputs = new HashMap<String, String>();
        private final List<String> importWarnings = new ArrayList<String>();

        public Signature(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public ImportedModel owner() {
            return ImportedModel.this;
        }

        public Map<String, String> inputs() {
            return Collections.unmodifiableMap(this.inputs);
        }

        public TensorType inputArgument(String inputName) {
            return this.owner().arguments().get(this.inputs.get(inputName));
        }

        public Map<String, String> outputs() {
            return Collections.unmodifiableMap(this.outputs);
        }

        public Map<String, String> skippedOutputs() {
            return Collections.unmodifiableMap(this.skippedOutputs);
        }

        public List<String> importWarnings() {
            return Collections.unmodifiableList(this.importWarnings);
        }

        public RankingExpression outputExpression(String outputName) {
            return this.owner().expressions().get(this.outputs.get(outputName));
        }

        public String toString() {
            return "signature '" + this.name + "'";
        }

        void input(String inputName, String argumentName) {
            this.inputs.put(inputName, argumentName);
        }

        void output(String name, String expressionName) {
            this.outputs.put(name, expressionName);
        }

        void skippedOutput(String name, String reason) {
            this.skippedOutputs.put(name, reason);
        }

        void importWarning(String warning) {
            this.importWarnings.add(warning);
        }
    }
}

