/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations;

import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations.TensorFlowOperation;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Concat;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;
import org.tensorflow.framework.NodeDef;

public class ConcatV2
extends TensorFlowOperation {
    private String concatDimensionName;

    public ConcatV2(String modelName, NodeDef node, List<TensorFlowOperation> inputs, int port) {
        super(modelName, node, inputs, port);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.inputs.stream().map(TensorFlowOperation::type).allMatch(Optional::isPresent)) {
            return null;
        }
        TensorFlowOperation concatDimOp = (TensorFlowOperation)this.inputs.get(this.inputs.size() - 1);
        if (!concatDimOp.getConstantValue().isPresent()) {
            throw new IllegalArgumentException("ConcatV2 in " + this.node.getName() + ": concat dimension must be a constant.");
        }
        Tensor concatDimTensor = concatDimOp.getConstantValue().get().asTensor();
        if (concatDimTensor.type().rank() != 0) {
            throw new IllegalArgumentException("ConcatV2 in " + this.node.getName() + ": concat dimension must be a scalar.");
        }
        OrderedTensorType aType = ((TensorFlowOperation)this.inputs.get(0)).type().get();
        int concatDim = (int)concatDimTensor.asDouble();
        long concatDimSize = aType.dimensions().get(concatDim).size().orElse(-1L);
        for (int i = 1; i < this.inputs.size() - 1; ++i) {
            OrderedTensorType bType = ((TensorFlowOperation)this.inputs.get(i)).type().get();
            if (bType.rank() != aType.rank()) {
                throw new IllegalArgumentException("ConcatV2 in " + this.node.getName() + ": inputs must have save rank.");
            }
            for (int j = 0; j < aType.rank(); ++j) {
                long dimSizeA = aType.dimensions().get(j).size().orElse(-1L);
                long dimSizeB = bType.dimensions().get(j).size().orElse(-1L);
                if (j == concatDim) {
                    concatDimSize += dimSizeB;
                    continue;
                }
                if (dimSizeA == dimSizeB) continue;
                throw new IllegalArgumentException("ConcatV2 in " + this.node.getName() + ": input dimension " + j + " differs in input tensors.");
            }
        }
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.node);
        int dimensionIndex = 0;
        for (TensorType.Dimension dimension : aType.dimensions()) {
            if (dimensionIndex == concatDim) {
                this.concatDimensionName = dimension.name();
                typeBuilder.add(TensorType.Dimension.indexed((String)this.concatDimensionName, (long)concatDimSize));
            } else {
                typeBuilder.add(dimension);
            }
            ++dimensionIndex;
        }
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.inputs.stream().map(TensorFlowOperation::function).allMatch(Optional::isPresent)) {
            return null;
        }
        TensorFunction result = ((TensorFlowOperation)this.inputs.get(0)).function().get();
        for (int i = 1; i < this.inputs.size() - 1; ++i) {
            TensorFunction b = ((TensorFlowOperation)this.inputs.get(i)).function().get();
            result = new Concat(result, b, this.concatDimensionName);
        }
        return result;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.inputs.stream().map(TensorFlowOperation::type).allMatch(Optional::isPresent)) {
            return;
        }
        OrderedTensorType a = ((TensorFlowOperation)this.inputs.get(0)).type().get();
        for (int i = 1; i < this.inputs.size() - 1; ++i) {
            OrderedTensorType b = ((TensorFlowOperation)this.inputs.get(i)).type().get();
            String bDim = b.dimensions().get(i).name();
            String aDim = a.dimensions().get(i).name();
            renamer.addConstraint(aDim, bDim, DimensionRenamer::equals, this);
        }
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        this.concatDimensionName = renamer.dimensionNameOf(this.concatDimensionName).orElse(this.concatDimensionName);
    }
}

