/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.onnx.importer.operations;

import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.TensorConverter;
import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.operations.OnnxOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.Collections;
import java.util.Optional;
import onnx.Onnx;

public class Constant
extends OnnxOperation {
    final Onnx.TensorProto tensorProto;

    public Constant(Onnx.TensorProto tensorProto) {
        super(null, Collections.emptyList());
        this.tensorProto = tensorProto;
    }

    @Override
    public String vespaName() {
        return this.vespaName(this.tensorProto.getName());
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return OrderedTensorType.fromOnnxType(this.tensorProto.getDimsList(), this.vespaName() + "_");
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        return null;
    }

    @Override
    public Optional<Value> getConstantValue() {
        return Optional.of(new TensorValue(TensorConverter.toVespaTensor(this.tensorProto, this.type)));
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (TensorType.Dimension dimension : this.type.type().dimensions()) {
            renamer.addDimension(dimension.name());
        }
    }

    @Override
    public boolean isConstant() {
        return true;
    }
}

