/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.onnx.importer.operations;

import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.operations.OnnxOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.VariableTensor;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.Collections;
import java.util.List;
import onnx.Onnx;

public class Argument
extends OnnxOperation {
    private Onnx.ValueInfoProto valueInfo;
    private OrderedTensorType standardNamingType;

    public Argument(Onnx.ValueInfoProto valueInfoProto) {
        super(null, Collections.emptyList());
        this.valueInfo = valueInfoProto;
        this.standardNamingType = OrderedTensorType.fromOnnxType(this.valueInfo.getType());
    }

    @Override
    public String vespaName() {
        return this.vespaName(this.valueInfo.getName());
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return OrderedTensorType.fromOnnxType(this.valueInfo.getType(), this.vespaName() + "_");
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        VariableTensor output = new VariableTensor(this.vespaName(), this.standardNamingType.type());
        if (!this.standardNamingType.equals(this.type)) {
            List<String> renameFrom = this.standardNamingType.dimensionNames();
            List<String> renameTo = this.type.dimensionNames();
            output = new Rename((TensorFunction)output, renameFrom, renameTo);
        }
        return output;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (TensorType.Dimension dimension : this.type.type().dimensions()) {
            renamer.addDimension(dimension.name());
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

