/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.onnx.importer;

import com.yahoo.searchlib.rankingexpression.integration.onnx.importer.operations.OnnxOperation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DimensionRenamer {
    private final String dimensionPrefix;
    private final Map<String, List<Integer>> variables = new HashMap<String, List<Integer>>();
    private final Map<Arc, Constraint> constraints = new HashMap<Arc, Constraint>();
    private final Map<String, Integer> renames = new HashMap<String, Integer>();
    private int iterations = 0;

    public DimensionRenamer() {
        this("d");
    }

    public DimensionRenamer(String dimensionPrefix) {
        this.dimensionPrefix = dimensionPrefix;
    }

    public void addDimension(String name) {
        this.variables.computeIfAbsent(name, d -> new ArrayList());
    }

    public void addConstraint(String from, String to, Constraint pred, OnnxOperation operation) {
        Arc arc = new Arc(from, to, operation);
        Arc opposite = arc.opposite();
        this.constraints.put(arc, pred);
        this.constraints.put(opposite, (x, y) -> pred.test(y, x));
    }

    public Optional<String> dimensionNameOf(String name) {
        if (!this.renames.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of(String.format("%s%d", this.dimensionPrefix, this.renames.get(name)));
    }

    public void solve(int maxIterations) {
        this.initialize();
        for (String dimension : this.variables.keySet()) {
            List<Integer> values = this.variables.get(dimension);
            if (values.size() > 1) {
                if (!this.ac3()) {
                    throw new IllegalArgumentException("Dimension renamer unable to find a solution.");
                }
                values.sort(Integer::compare);
                this.variables.put(dimension, Collections.singletonList(values.get(0)));
            }
            this.renames.put(dimension, this.variables.get(dimension).get(0));
            if (this.iterations <= maxIterations) continue;
            throw new IllegalArgumentException("Dimension renamer unable to find a solution within " + maxIterations + " iterations");
        }
    }

    public void solve() {
        this.solve(100000);
    }

    private void initialize() {
        for (Map.Entry<String, List<Integer>> variable : this.variables.entrySet()) {
            List<Integer> values = variable.getValue();
            for (int i = 0; i < this.variables.size(); ++i) {
                values.add(i);
            }
        }
    }

    private boolean ac3() {
        ArrayDeque<Arc> workList = new ArrayDeque<Arc>(this.constraints.keySet());
        while (!workList.isEmpty()) {
            Arc arc = (Arc)workList.pop();
            ++this.iterations;
            if (!this.revise(arc)) continue;
            if (this.variables.get(arc.from).size() == 0) {
                return false;
            }
            for (Arc constraint : this.constraints.keySet()) {
                if (!arc.from.equals(constraint.to) || arc.to.equals(constraint.from)) continue;
                workList.add(constraint);
            }
        }
        return true;
    }

    private boolean revise(Arc arc) {
        boolean revised = false;
        Iterator<Integer> fromIterator = this.variables.get(arc.from).iterator();
        while (fromIterator.hasNext()) {
            Integer from = fromIterator.next();
            boolean satisfied = false;
            for (Integer to : this.variables.get(arc.to)) {
                if (!this.constraints.get(arc).test(from, to)) continue;
                satisfied = true;
            }
            if (satisfied) continue;
            fromIterator.remove();
            revised = true;
        }
        return revised;
    }

    public static boolean equals(Integer x, Integer y) {
        return Objects.equals(x, y);
    }

    public static boolean lesserThan(Integer x, Integer y) {
        return x < y;
    }

    public static boolean greaterThan(Integer x, Integer y) {
        return x > y;
    }

    private static class Arc {
        private final String from;
        private final String to;
        private final OnnxOperation operation;

        Arc(String from, String to, OnnxOperation operation) {
            this.from = from;
            this.to = to;
            this.operation = operation;
        }

        Arc opposite() {
            return new Arc(this.to, this.from, this.operation);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Arc)) {
                return false;
            }
            Arc other = (Arc)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
        }

        public String toString() {
            return String.format("%s -> %s", this.from, this.to);
        }
    }

    public static interface Constraint {
        public boolean test(Integer var1, Integer var2);
    }
}

