/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.onnx;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OnnxModel {
    private final String output;
    private final Map<String, TensorType> arguments = new HashMap<String, TensorType>();
    private final Map<String, Tensor> smallConstants = new HashMap<String, Tensor>();
    private final Map<String, Tensor> largeConstants = new HashMap<String, Tensor>();
    private final Map<String, RankingExpression> expressions = new HashMap<String, RankingExpression>();
    private final Map<String, TensorType> requiredMacros = new HashMap<String, TensorType>();

    public OnnxModel(String outputNode) {
        this.output = outputNode;
    }

    void argument(String name, TensorType argumentType) {
        this.arguments.put(name, argumentType);
    }

    void smallConstant(String name, Tensor constant) {
        this.smallConstants.put(name, constant);
    }

    void largeConstant(String name, Tensor constant) {
        this.largeConstants.put(name, constant);
    }

    void expression(String name, RankingExpression expression) {
        this.expressions.put(name, expression);
    }

    void requiredMacro(String name, TensorType type) {
        this.requiredMacros.put(name, type);
    }

    public String output() {
        return this.output;
    }

    public Map<String, TensorType> arguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public Map<String, Tensor> smallConstants() {
        return Collections.unmodifiableMap(this.smallConstants);
    }

    public Map<String, Tensor> largeConstants() {
        return Collections.unmodifiableMap(this.largeConstants);
    }

    public Map<String, RankingExpression> expressions() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public Map<String, TensorType> requiredMacros() {
        return Collections.unmodifiableMap(this.requiredMacros);
    }
}

