/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public final class IfNode
extends CompositeNode {
    private final ExpressionNode condition;
    private final ExpressionNode trueExpression;
    private final ExpressionNode falseExpression;
    private final Double trueProbability;

    public IfNode(ExpressionNode condition, ExpressionNode trueExpression, ExpressionNode falseExpression) {
        this(condition, trueExpression, falseExpression, null);
    }

    public IfNode(ExpressionNode condition, ExpressionNode trueExpression, ExpressionNode falseExpression, Double trueProbability) {
        if (trueProbability != null && (trueProbability < 0.0 || trueProbability > 1.0)) {
            throw new IllegalArgumentException("trueProbability must be a between 0.0 and 1.0, not " + trueProbability);
        }
        this.condition = condition;
        this.trueProbability = trueProbability;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public List<ExpressionNode> children() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>(4);
        children.add(this.condition);
        children.add(this.trueExpression);
        children.add(this.falseExpression);
        return Collections.unmodifiableList(children);
    }

    public ExpressionNode getCondition() {
        return this.condition;
    }

    public ExpressionNode getTrueExpression() {
        return this.trueExpression;
    }

    public ExpressionNode getFalseExpression() {
        return this.falseExpression;
    }

    public Double getTrueProbability() {
        return this.trueProbability;
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        return "if (" + this.condition.toString(context, path, this) + ", " + this.trueExpression.toString(context, path, this) + ", " + this.falseExpression.toString(context, path, this) + (this.trueProbability != null ? ", " + this.trueProbability : "") + ")";
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        TensorType trueType = this.trueExpression.type(context);
        TensorType falseType = this.falseExpression.type(context);
        return (TensorType)trueType.dimensionwiseGeneralizationWith(falseType).orElseThrow(() -> new IllegalArgumentException("An if expression must produce compatible types in both alternatives, but the 'true' type is " + trueType + " while the 'false' type is " + falseType));
    }

    @Override
    public Value evaluate(Context context) {
        if (this.condition.evaluate(context).asBoolean()) {
            return this.trueExpression.evaluate(context);
        }
        return this.falseExpression.evaluate(context);
    }

    @Override
    public IfNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 3) {
            throw new IllegalArgumentException("Expected 3 children but got " + children.size());
        }
        return new IfNode(children.get(0), children.get(1), children.get(2));
    }
}

