/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations;

import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.TensorConverter;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations.TensorFlowOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.NodeDef;

public class Squeeze
extends TensorFlowOperation {
    private List<String> squeezeDimensions;

    public Squeeze(String modelName, NodeDef node, List<TensorFlowOperation> inputs, int port) {
        super(modelName, node, inputs, port);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        OrderedTensorType inputType = ((TensorFlowOperation)this.inputs.get(0)).type().get();
        this.squeezeDimensions = new ArrayList<String>();
        AttrValue squeezeDimsAttr = (AttrValue)this.node.getAttrMap().get("squeeze_dims");
        this.squeezeDimensions = squeezeDimsAttr == null ? inputType.type().dimensions().stream().filter(dim -> TensorConverter.dimensionSize(dim) == 1L).map(TensorType.Dimension::name).collect(Collectors.toList()) : squeezeDimsAttr.getList().getIList().stream().map(i -> i < 0L ? (long)inputType.type().dimensions().size() - i : i).map(i -> (TensorType.Dimension)inputType.type().dimensions().get(i.intValue())).filter(dim -> TensorConverter.dimensionSize(dim) == 1L).map(TensorType.Dimension::name).collect(Collectors.toList());
        return this.squeezeDimensions.isEmpty() ? inputType : this.reducedType(inputType);
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputFunctionsPresent(1)) {
            return null;
        }
        TensorFunction inputFunction = ((TensorFlowOperation)this.inputs.get(0)).function().get();
        return new Reduce(inputFunction, Reduce.Aggregator.sum, this.squeezeDimensions);
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        ArrayList<String> renamedDimensions = new ArrayList<String>(this.squeezeDimensions.size());
        for (String name : this.squeezeDimensions) {
            Optional<String> newName = renamer.dimensionNameOf(name);
            if (!newName.isPresent()) {
                return;
            }
            renamedDimensions.add(newName.get());
        }
        this.squeezeDimensions = renamedDimensions;
    }

    private OrderedTensorType reducedType(OrderedTensorType inputType) {
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(this.node);
        for (TensorType.Dimension dimension : inputType.type().dimensions()) {
            if (this.squeezeDimensions.contains(dimension.name())) continue;
            builder.add(dimension);
        }
        return builder.build();
    }
}

