/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression;

import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParser;
import com.yahoo.searchlib.rankingexpression.parser.TokenMgrError;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RankingExpression
implements Serializable {
    private String name = "";
    private ExpressionNode root;

    public RankingExpression(Reader reader) throws ParseException {
        this.root = RankingExpression.parse(reader);
    }

    public RankingExpression(String name, Reader reader) throws ParseException {
        this.name = name;
        this.root = RankingExpression.parse(reader);
    }

    public RankingExpression(String name, String expression) throws ParseException {
        try {
            this.name = name;
            if (expression == null || expression.length() == 0) {
                throw new IllegalArgumentException("Empty ranking expressions are not allowed");
            }
            this.root = RankingExpression.parse(new StringReader(expression));
        }
        catch (ParseException e) {
            ParseException p = new ParseException("Could not parse '" + expression + "'");
            p.initCause(e);
            throw p;
        }
    }

    public RankingExpression(String expression) throws ParseException {
        this("", expression);
    }

    public RankingExpression(File file) throws ParseException {
        try {
            this.name = file.getName().split("\\.")[0];
            this.root = RankingExpression.parse(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not create a ranking expression", e);
        }
    }

    public RankingExpression(String name, ExpressionNode root) {
        this.name = name;
        this.root = root;
    }

    public RankingExpression(ExpressionNode root) {
        this.root = root;
    }

    private static ExpressionNode parse(Reader reader) throws ParseException {
        try {
            return new RankingExpressionParser(reader).rankingExpression();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExpressionNode getRoot() {
        return this.root;
    }

    public void setRoot(ExpressionNode root) {
        this.root = root;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RankingExpression && this.toString().equals(obj.toString());
    }

    public String toString() {
        if ("".equals(this.name)) {
            return this.root.toString();
        }
        return this.name + ": " + this.root.toString();
    }

    public Map<String, String> getRankProperties(List<ExpressionFunction> macros) {
        LinkedList<String> path = new LinkedList<String>();
        SerializationContext context = new SerializationContext(macros);
        String serializedRoot = this.root.toString(context, path, null);
        Map<String, String> serializedExpressions = context.serializedFunctions();
        serializedExpressions.put(RankingExpression.propertyName(this.name), serializedRoot);
        return serializedExpressions;
    }

    public static String propertyName(String expressionName) {
        return "rankingExpression(" + expressionName + ").rankingScript";
    }

    public TensorType type(TypeContext<Reference> context) {
        return this.root.type(context);
    }

    public Value evaluate(Context context) {
        return this.root.evaluate(context);
    }

    public static RankingExpression from(String expression) {
        try {
            return new RankingExpression(expression);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }
}

