/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;

@Beta
public class TensorFunctionNode
extends CompositeNode {
    private final TensorFunction function;

    public TensorFunctionNode(TensorFunction function) {
        this.function = function;
    }

    public TensorFunction function() {
        return this.function;
    }

    @Override
    public List<ExpressionNode> children() {
        return this.function.arguments().stream().map(this::toExpressionNode).collect(Collectors.toList());
    }

    private ExpressionNode toExpressionNode(TensorFunction f) {
        if (f instanceof TensorFunctionExpressionNode) {
            return ((TensorFunctionExpressionNode)f).expression;
        }
        return new TensorFunctionNode(f);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> children) {
        List wrappedChildren = children.stream().map(TensorFunctionExpressionNode::new).collect(Collectors.toList());
        return new TensorFunctionNode(this.function.withArguments(wrappedChildren));
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        return this.function.toPrimitive().toString((ToStringContext)new ExpressionNodeToStringContext(context, path, this));
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        return this.function.type(context);
    }

    @Override
    public Value evaluate(Context context) {
        return new TensorValue(this.function.evaluate((EvaluationContext)context));
    }

    public static TensorFunctionExpressionNode wrapArgument(ExpressionNode node) {
        return new TensorFunctionExpressionNode(node);
    }

    private static class ExpressionNodeToStringContext
    implements ToStringContext {
        final SerializationContext context;
        final Deque<String> path;
        final CompositeNode parent;
        public static final ExpressionNodeToStringContext empty = new ExpressionNodeToStringContext(new SerializationContext(), null, null);

        public ExpressionNodeToStringContext(SerializationContext context, Deque<String> path, CompositeNode parent) {
            this.context = context;
            this.path = path;
            this.parent = parent;
        }
    }

    public static class TensorFunctionExpressionNode
    extends PrimitiveTensorFunction {
        private final ExpressionNode expression;

        public TensorFunctionExpressionNode(ExpressionNode expression) {
            this.expression = expression;
        }

        public List<TensorFunction> arguments() {
            if (this.expression instanceof CompositeNode) {
                return ((CompositeNode)this.expression).children().stream().map(TensorFunctionExpressionNode::new).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        public TensorFunction withArguments(List<TensorFunction> arguments) {
            if (arguments.size() == 0) {
                return this;
            }
            List<ExpressionNode> unwrappedChildren = arguments.stream().map(arg -> ((TensorFunctionExpressionNode)arg).expression).collect(Collectors.toList());
            return new TensorFunctionExpressionNode(((CompositeNode)this.expression).setChildren(unwrappedChildren));
        }

        public PrimitiveTensorFunction toPrimitive() {
            return this;
        }

        public <NAMETYPE extends TypeContext.Name> TensorType type(TypeContext<NAMETYPE> context) {
            return this.expression.type(context);
        }

        public <NAMETYPE extends TypeContext.Name> Tensor evaluate(EvaluationContext<NAMETYPE> context) {
            return this.expression.evaluate((Context)context).asTensor();
        }

        public String toString() {
            return this.toString(ExpressionNodeToStringContext.empty);
        }

        public String toString(ToStringContext c) {
            if (c instanceof ExpressionNodeToStringContext) {
                ExpressionNodeToStringContext context = (ExpressionNodeToStringContext)c;
                return this.expression.toString(context.context, context.path, context.parent);
            }
            return this.expression.toString();
        }
    }
}

