/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.Join;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class ArithmeticNode
extends CompositeNode {
    private final ImmutableList<ExpressionNode> children;
    private final ImmutableList<ArithmeticOperator> operators;

    public ArithmeticNode(List<ExpressionNode> children, List<ArithmeticOperator> operators) {
        this.children = ImmutableList.copyOf(children);
        this.operators = ImmutableList.copyOf(operators);
    }

    public ArithmeticNode(ExpressionNode leftExpression, ArithmeticOperator operator, ExpressionNode rightExpression) {
        this.children = ImmutableList.of((Object)leftExpression, (Object)rightExpression);
        this.operators = ImmutableList.of((Object)((Object)operator));
    }

    public List<ArithmeticOperator> operators() {
        return this.operators;
    }

    @Override
    public List<ExpressionNode> children() {
        return this.children;
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        StringBuilder string = new StringBuilder();
        boolean nonDefaultPrecedence = this.nonDefaultPrecedence(parent);
        if (nonDefaultPrecedence) {
            string.append("(");
        }
        UnmodifiableIterator child = this.children.iterator();
        string.append(((ExpressionNode)child.next()).toString(context, path, this)).append(" ");
        UnmodifiableIterator op = this.operators.iterator();
        while (op.hasNext() && child.hasNext()) {
            string.append(((ArithmeticOperator)((Object)op.next())).toString()).append(" ");
            string.append(((ExpressionNode)child.next()).toString(context, path, this));
            if (!op.hasNext()) continue;
            string.append(" ");
        }
        if (nonDefaultPrecedence) {
            string.append(")");
        }
        string.append(" ");
        return string.toString().trim();
    }

    private boolean nonDefaultPrecedence(CompositeNode parent) {
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof ArithmeticNode)) {
            return false;
        }
        ArithmeticNode arithParent = (ArithmeticNode)parent;
        return ((ArithmeticOperator)((Object)arithParent.operators.get(0))).hasPrecedenceOver((ArithmeticOperator)((Object)this.operators.get(0))) || arithParent.operators.size() > 1 || this.operators.size() > 1;
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        TensorType type = ((ExpressionNode)this.children.get(0)).type(context);
        for (int i = 1; i < this.children.size(); ++i) {
            type = Join.outputType((TensorType)type, (TensorType)((ExpressionNode)this.children.get(i)).type(context));
        }
        return type;
    }

    @Override
    public Value evaluate(Context context) {
        UnmodifiableIterator child = this.children.iterator();
        ArrayDeque<ValueItem> stack = new ArrayDeque<ValueItem>();
        stack.push(new ValueItem(ArithmeticOperator.OR, ((ExpressionNode)child.next()).evaluate(context)));
        UnmodifiableIterator it = this.operators.iterator();
        while (it.hasNext() && child.hasNext()) {
            ArithmeticOperator op = (ArithmeticOperator)((Object)it.next());
            if (!stack.isEmpty()) {
                while (((ValueItem)stack.peek()).op.hasPrecedenceOver(op)) {
                    this.popStack(stack);
                }
            }
            stack.push(new ValueItem(op, ((ExpressionNode)child.next()).evaluate(context)));
        }
        while (stack.size() > 1) {
            this.popStack(stack);
        }
        return ((ValueItem)stack.getFirst()).value;
    }

    private void popStack(Deque<ValueItem> stack) {
        ValueItem rhs = stack.pop();
        ValueItem lhs = stack.peek();
        lhs.value = rhs.op.evaluate(lhs.value, rhs.value);
    }

    public static ArithmeticNode resolve(ExpressionNode left, ArithmeticOperator op, ExpressionNode right) {
        if (!(left instanceof ArithmeticNode)) {
            return new ArithmeticNode(left, op, right);
        }
        ArithmeticNode leftArithmetic = (ArithmeticNode)left;
        ArrayList<ExpressionNode> newChildren = new ArrayList<ExpressionNode>(leftArithmetic.children());
        newChildren.add(right);
        ArrayList<ArithmeticOperator> newOperators = new ArrayList<ArithmeticOperator>(leftArithmetic.operators());
        newOperators.add(op);
        return new ArithmeticNode(newChildren, newOperators);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> newChildren) {
        if (this.children.size() != newChildren.size()) {
            throw new IllegalArgumentException("Expected " + this.children.size() + " children but got " + newChildren.size());
        }
        return new ArithmeticNode(newChildren, (List<ArithmeticOperator>)this.operators);
    }

    private static class ValueItem {
        final ArithmeticOperator op;
        Value value;

        public ValueItem(ArithmeticOperator op, Value value) {
            this.op = op;
            this.value = value;
        }
    }
}

