/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations;

import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations.TensorFlowOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;
import org.tensorflow.framework.NodeDef;

public class Matmul
extends TensorFlowOperation {
    public Matmul(String modelName, NodeDef node, List<TensorFlowOperation> inputs, int port) {
        super(modelName, node, inputs, port);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.node);
        typeBuilder.add(((TensorFlowOperation)this.inputs.get(0)).type().get().dimensions().get(0));
        typeBuilder.add(((TensorFlowOperation)this.inputs.get(1)).type().get().dimensions().get(1));
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        OrderedTensorType aType = ((TensorFlowOperation)this.inputs.get(0)).type().get();
        OrderedTensorType bType = ((TensorFlowOperation)this.inputs.get(1)).type().get();
        if (aType.type().rank() < 2 || bType.type().rank() < 2) {
            throw new IllegalArgumentException("Tensors in matmul must have rank of at least 2");
        }
        if (aType.type().rank() != bType.type().rank()) {
            throw new IllegalArgumentException("Tensors in matmul must have the same rank");
        }
        Optional<TensorFunction> aFunction = ((TensorFlowOperation)this.inputs.get(0)).function();
        Optional<TensorFunction> bFunction = ((TensorFlowOperation)this.inputs.get(1)).function();
        if (!aFunction.isPresent() || !bFunction.isPresent()) {
            return null;
        }
        return new com.yahoo.tensor.functions.Matmul(aFunction.get(), bFunction.get(), aType.dimensions().get(1).name());
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.allInputTypesPresent(2)) {
            return;
        }
        List<TensorType.Dimension> aDimensions = ((TensorFlowOperation)this.inputs.get(0)).type().get().dimensions();
        List<TensorType.Dimension> bDimensions = ((TensorFlowOperation)this.inputs.get(1)).type().get().dimensions();
        String aDim0 = aDimensions.get(0).name();
        String aDim1 = aDimensions.get(1).name();
        String bDim0 = bDimensions.get(0).name();
        String bDim1 = bDimensions.get(1).name();
        renamer.addConstraint(aDim1, bDim0, DimensionRenamer::equals, this);
        renamer.addConstraint(aDim0, bDim1, DimensionRenamer::lesserThan, this);
        renamer.addConstraint(aDim0, aDim1, DimensionRenamer::lesserThan, this);
        renamer.addConstraint(bDim0, bDim1, DimensionRenamer::greaterThan, this);
    }
}

