/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations;

import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations.TensorFlowOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.VariableTensor;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import org.tensorflow.framework.NodeDef;

public class Placeholder
extends TensorFlowOperation {
    private OrderedTensorType standardNamingType;

    public Placeholder(NodeDef node, List<TensorFlowOperation> inputs, int port) {
        super(node, inputs, port);
        this.standardNamingType = OrderedTensorType.fromTensorFlowType(node);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return OrderedTensorType.fromTensorFlowType(this.node, this.vespaName() + "_");
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        VariableTensor output = new VariableTensor(this.vespaName(), this.standardNamingType.type());
        if (!this.standardNamingType.equals(this.type)) {
            List<String> renameFrom = this.standardNamingType.dimensionNames();
            List<String> renameTo = this.type.dimensionNames();
            output = new Rename((TensorFunction)output, renameFrom, renameTo);
        }
        return output;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (TensorType.Dimension dimension : this.type.type().dimensions()) {
            renamer.addDimension(dimension.name());
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

