/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations;

import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.tensorflow.importer.operations.TensorFlowOperation;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.tensorflow.framework.NodeDef;

public class ExpandDims
extends TensorFlowOperation {
    private List<String> expandDimensions;

    public ExpandDims(NodeDef node, List<TensorFlowOperation> inputs, int port) {
        super(node, inputs, port);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        TensorFlowOperation axisOperation = this.inputs().get(1);
        if (!axisOperation.getConstantValue().isPresent()) {
            throw new IllegalArgumentException("ExpandDims in " + this.node.getName() + ": axis must be a constant.");
        }
        Tensor axis = axisOperation.getConstantValue().get().asTensor();
        if (axis.type().rank() != 0) {
            throw new IllegalArgumentException("ExpandDims in " + this.node.getName() + ": axis argument must be a scalar.");
        }
        OrderedTensorType inputType = ((TensorFlowOperation)this.inputs.get(0)).type().get();
        int dimensionToInsert = (int)axis.asDouble();
        if (dimensionToInsert < 0) {
            dimensionToInsert = inputType.dimensions().size() - dimensionToInsert;
        }
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.node);
        this.expandDimensions = new ArrayList<String>();
        int dimensionIndex = 0;
        for (TensorType.Dimension dimension : inputType.dimensions()) {
            if (dimensionIndex == dimensionToInsert) {
                String name = String.format("%s_%d", this.vespaName(), dimensionIndex);
                this.expandDimensions.add(name);
                typeBuilder.add(TensorType.Dimension.indexed((String)name, (long)1L));
            }
            typeBuilder.add(dimension);
            ++dimensionIndex;
        }
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputFunctionsPresent(2)) {
            return null;
        }
        TensorType.Builder typeBuilder = new TensorType.Builder();
        for (String name : this.expandDimensions) {
            typeBuilder.indexed(name, 1L);
        }
        TensorType generatedType = typeBuilder.build();
        ConstantNode generatedExpression = new ConstantNode(new DoubleValue(1.0));
        Generate generatedFunction = new Generate(generatedType, (Function)new GeneratorLambdaFunctionNode(generatedType, generatedExpression).asLongListToDoubleOperator());
        return new Join(this.inputs().get(0).function().get(), (TensorFunction)generatedFunction, ScalarFunctions.multiply());
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (TensorType.Dimension dimension : this.type.type().dimensions()) {
            renamer.addDimension(dimension.name());
        }
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        ArrayList<String> renamedDimensions = new ArrayList<String>(this.expandDimensions.size());
        for (String name : this.expandDimensions) {
            Optional<String> newName = renamer.dimensionNameOf(name);
            if (!newName.isPresent()) {
                return;
            }
            renamedDimensions.add(newName.get());
        }
        this.expandDimensions = renamedDimensions;
    }
}

