/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public final class ReferenceNode
extends CompositeNode {
    private final String name;
    private final String output;
    private final Arguments arguments;

    public ReferenceNode(String name) {
        this(name, null, null);
    }

    public ReferenceNode(String name, List<? extends ExpressionNode> arguments, String output) {
        this.name = name;
        this.arguments = arguments != null ? new Arguments(arguments) : new Arguments();
        this.output = output;
    }

    public String getName() {
        return this.name;
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    public ReferenceNode setArguments(List<ExpressionNode> arguments) {
        return new ReferenceNode(this.name, arguments, this.output);
    }

    public String getOutput() {
        return this.output;
    }

    public ReferenceNode setOutput(String output) {
        return new ReferenceNode(this.name, this.arguments.expressions(), output);
    }

    @Override
    public List<ExpressionNode> children() {
        return this.arguments.expressions();
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        ExpressionFunction function;
        if (path == null) {
            path = new ArrayDeque<String>();
        }
        String myName = this.name;
        String myOutput = this.output;
        List<ExpressionNode> myArguments = this.arguments.expressions();
        String resolvedArgument = context.getBinding(myName);
        if (resolvedArgument != null && this.arguments.expressions().size() == 0 && myOutput == null) {
            myName = resolvedArgument;
            myArguments = null;
            myOutput = null;
        } else if (context.getFunction(myName) != null && (function = context.getFunction(myName)) != null && myArguments != null && function.arguments().size() == myArguments.size() && myOutput == null) {
            String myPath = this.name + this.arguments.expressions();
            if (path.contains(myPath)) {
                throw new IllegalStateException("Cycle in ranking expression function: " + path);
            }
            path.addLast(myPath);
            ExpressionFunction.Instance instance = function.expand(context, myArguments, path);
            path.removeLast();
            context.addFunctionSerialization(RankingExpression.propertyName(instance.getName()), instance.getExpressionString());
            myName = "rankingExpression(" + instance.getName() + ")";
            myArguments = null;
            myOutput = null;
        }
        StringBuilder ret = new StringBuilder(myName);
        if (myArguments != null && myArguments.size() > 0) {
            ret.append("(");
            for (int i = 0; i < myArguments.size(); ++i) {
                ret.append(myArguments.get(i).toString(context, path, this));
                if (i >= myArguments.size() - 1) continue;
                ret.append(",");
            }
            ret.append(")");
        }
        ret.append(myOutput != null ? "." + myOutput : "");
        return ret.toString();
    }

    @Override
    public TensorType type(TypeContext context) {
        return context.getType(this.toString());
    }

    @Override
    public Value evaluate(Context context) {
        if (this.arguments.expressions().isEmpty() && this.output == null) {
            return context.get(this.name);
        }
        return context.get(this.name, this.arguments, this.output);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> newChildren) {
        return new ReferenceNode(this.name, newChildren, this.output);
    }
}

