/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public final class FunctionNode
extends CompositeNode {
    private final Function function;
    private final Arguments arguments;

    public FunctionNode(Function function, ExpressionNode argument) {
        if (function.arity() != 1) {
            throw new IllegalArgumentException(function + " is not unary");
        }
        this.function = function;
        this.arguments = new Arguments(Collections.singletonList(argument));
    }

    public FunctionNode(Function function, ExpressionNode argument1, ExpressionNode argument2) {
        if (function.arity() != 2) {
            throw new IllegalArgumentException(function + " is not binary");
        }
        this.function = function;
        ArrayList<ExpressionNode> argumentList = new ArrayList<ExpressionNode>();
        argumentList.add(argument1);
        argumentList.add(argument2);
        this.arguments = new Arguments(argumentList);
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public List<ExpressionNode> children() {
        return this.arguments.expressions();
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        StringBuilder b = new StringBuilder(this.function.toString());
        b.append("(");
        for (int i = 0; i < this.arguments.expressions().size(); ++i) {
            b.append(this.arguments.expressions().get(i).toString(context, path, this));
            if (i >= this.arguments.expressions().size() - 1) continue;
            b.append(",");
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public TensorType type(TypeContext context) {
        if (this.arguments.expressions().size() == 0) {
            return TensorType.empty;
        }
        TensorType argument1Type = this.arguments.expressions().get(0).type(context);
        if (this.arguments.expressions().size() == 1) {
            return argument1Type;
        }
        TensorType argument2Type = this.arguments.expressions().get(1).type(context);
        return Join.outputType((TensorType)argument1Type, (TensorType)argument2Type);
    }

    @Override
    public Value evaluate(Context context) {
        if (this.arguments.expressions().size() == 0) {
            return DoubleValue.zero.function(this.function, DoubleValue.zero);
        }
        Value argument1 = this.arguments.expressions().get(0).evaluate(context);
        if (this.arguments.expressions().size() == 1) {
            return argument1.function(this.function, DoubleValue.zero);
        }
        Value argument2 = this.arguments.expressions().get(1).evaluate(context);
        return argument1.function(this.function, argument2);
    }

    @Override
    public FunctionNode setChildren(List<ExpressionNode> children) {
        if (this.arguments.expressions().size() != children.size()) {
            throw new IllegalArgumentException("Expected " + this.arguments.expressions().size() + " children but got " + children.size());
        }
        if (children.size() == 1) {
            return new FunctionNode(this.function, children.get(0));
        }
        return new FunctionNode(this.function, children.get(0), children.get(1));
    }
}

